/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.EvaluationFrequency;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupArnListCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLogAnomalyDetectorRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, CreateLogAnomalyDetectorRequest> {
    private static final SdkField<List<String>> LOG_GROUP_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroupArnList").getter(CreateLogAnomalyDetectorRequest.getter(CreateLogAnomalyDetectorRequest::logGroupArnList)).setter(CreateLogAnomalyDetectorRequest.setter(Builder::logGroupArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DETECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorName").getter(CreateLogAnomalyDetectorRequest.getter(CreateLogAnomalyDetectorRequest::detectorName)).setter(CreateLogAnomalyDetectorRequest.setter(Builder::detectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorName").build()}).build();
    private static final SdkField<String> EVALUATION_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationFrequency").getter(CreateLogAnomalyDetectorRequest.getter(CreateLogAnomalyDetectorRequest::evaluationFrequencyAsString)).setter(CreateLogAnomalyDetectorRequest.setter(Builder::evaluationFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationFrequency").build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPattern").getter(CreateLogAnomalyDetectorRequest.getter(CreateLogAnomalyDetectorRequest::filterPattern)).setter(CreateLogAnomalyDetectorRequest.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(CreateLogAnomalyDetectorRequest.getter(CreateLogAnomalyDetectorRequest::kmsKeyId)).setter(CreateLogAnomalyDetectorRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Long> ANOMALY_VISIBILITY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("anomalyVisibilityTime").getter(CreateLogAnomalyDetectorRequest.getter(CreateLogAnomalyDetectorRequest::anomalyVisibilityTime)).setter(CreateLogAnomalyDetectorRequest.setter(Builder::anomalyVisibilityTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyVisibilityTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateLogAnomalyDetectorRequest.getter(CreateLogAnomalyDetectorRequest::tags)).setter(CreateLogAnomalyDetectorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_ARN_LIST_FIELD, DETECTOR_NAME_FIELD, EVALUATION_FREQUENCY_FIELD, FILTER_PATTERN_FIELD, KMS_KEY_ID_FIELD, ANOMALY_VISIBILITY_TIME_FIELD, TAGS_FIELD));
    private final List<String> logGroupArnList;
    private final String detectorName;
    private final String evaluationFrequency;
    private final String filterPattern;
    private final String kmsKeyId;
    private final Long anomalyVisibilityTime;
    private final Map<String, String> tags;

    private CreateLogAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupArnList = builder.logGroupArnList;
        this.detectorName = builder.detectorName;
        this.evaluationFrequency = builder.evaluationFrequency;
        this.filterPattern = builder.filterPattern;
        this.kmsKeyId = builder.kmsKeyId;
        this.anomalyVisibilityTime = builder.anomalyVisibilityTime;
        this.tags = builder.tags;
    }

    public final boolean hasLogGroupArnList() {
        return this.logGroupArnList != null && !(this.logGroupArnList instanceof SdkAutoConstructList);
    }

    public final List<String> logGroupArnList() {
        return this.logGroupArnList;
    }

    public final String detectorName() {
        return this.detectorName;
    }

    public final EvaluationFrequency evaluationFrequency() {
        return EvaluationFrequency.fromValue(this.evaluationFrequency);
    }

    public final String evaluationFrequencyAsString() {
        return this.evaluationFrequency;
    }

    public final String filterPattern() {
        return this.filterPattern;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Long anomalyVisibilityTime() {
        return this.anomalyVisibilityTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupArnList() ? this.logGroupArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyVisibilityTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLogAnomalyDetectorRequest)) {
            return false;
        }
        CreateLogAnomalyDetectorRequest other = (CreateLogAnomalyDetectorRequest)((Object)obj);
        return this.hasLogGroupArnList() == other.hasLogGroupArnList() && Objects.equals(this.logGroupArnList(), other.logGroupArnList()) && Objects.equals(this.detectorName(), other.detectorName()) && Objects.equals(this.evaluationFrequencyAsString(), other.evaluationFrequencyAsString()) && Objects.equals(this.filterPattern(), other.filterPattern()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.anomalyVisibilityTime(), other.anomalyVisibilityTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLogAnomalyDetectorRequest").add("LogGroupArnList", this.hasLogGroupArnList() ? this.logGroupArnList() : null).add("DetectorName", (Object)this.detectorName()).add("EvaluationFrequency", (Object)this.evaluationFrequencyAsString()).add("FilterPattern", (Object)this.filterPattern()).add("KmsKeyId", (Object)this.kmsKeyId()).add("AnomalyVisibilityTime", (Object)this.anomalyVisibilityTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupArnList": {
                return Optional.ofNullable(clazz.cast(this.logGroupArnList()));
            }
            case "detectorName": {
                return Optional.ofNullable(clazz.cast(this.detectorName()));
            }
            case "evaluationFrequency": {
                return Optional.ofNullable(clazz.cast(this.evaluationFrequencyAsString()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "anomalyVisibilityTime": {
                return Optional.ofNullable(clazz.cast(this.anomalyVisibilityTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLogAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((CreateLogAnomalyDetectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private List<String> logGroupArnList = DefaultSdkAutoConstructList.getInstance();
        private String detectorName;
        private String evaluationFrequency;
        private String filterPattern;
        private String kmsKeyId;
        private Long anomalyVisibilityTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLogAnomalyDetectorRequest model) {
            super(model);
            this.logGroupArnList(model.logGroupArnList);
            this.detectorName(model.detectorName);
            this.evaluationFrequency(model.evaluationFrequency);
            this.filterPattern(model.filterPattern);
            this.kmsKeyId(model.kmsKeyId);
            this.anomalyVisibilityTime(model.anomalyVisibilityTime);
            this.tags(model.tags);
        }

        public final Collection<String> getLogGroupArnList() {
            if (this.logGroupArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupArnList;
        }

        public final void setLogGroupArnList(Collection<String> logGroupArnList) {
            this.logGroupArnList = LogGroupArnListCopier.copy(logGroupArnList);
        }

        @Override
        public final Builder logGroupArnList(Collection<String> logGroupArnList) {
            this.logGroupArnList = LogGroupArnListCopier.copy(logGroupArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupArnList(String ... logGroupArnList) {
            this.logGroupArnList(Arrays.asList(logGroupArnList));
            return this;
        }

        public final String getDetectorName() {
            return this.detectorName;
        }

        public final void setDetectorName(String detectorName) {
            this.detectorName = detectorName;
        }

        @Override
        public final Builder detectorName(String detectorName) {
            this.detectorName = detectorName;
            return this;
        }

        public final String getEvaluationFrequency() {
            return this.evaluationFrequency;
        }

        public final void setEvaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
        }

        @Override
        public final Builder evaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
            return this;
        }

        @Override
        public final Builder evaluationFrequency(EvaluationFrequency evaluationFrequency) {
            this.evaluationFrequency(evaluationFrequency == null ? null : evaluationFrequency.toString());
            return this;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Long getAnomalyVisibilityTime() {
            return this.anomalyVisibilityTime;
        }

        public final void setAnomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
        }

        @Override
        public final Builder anomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLogAnomalyDetectorRequest build() {
            return new CreateLogAnomalyDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLogAnomalyDetectorRequest> {
        public Builder logGroupArnList(Collection<String> var1);

        public Builder logGroupArnList(String ... var1);

        public Builder detectorName(String var1);

        public Builder evaluationFrequency(String var1);

        public Builder evaluationFrequency(EvaluationFrequency var1);

        public Builder filterPattern(String var1);

        public Builder kmsKeyId(String var1);

        public Builder anomalyVisibilityTime(Long var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

