/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.SuppressionUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuppressionPeriod
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuppressionPeriod> {
    private static final SdkField<Integer> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("value").getter(SuppressionPeriod.getter(SuppressionPeriod::value)).setter(SuppressionPeriod.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> SUPPRESSION_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suppressionUnit").getter(SuppressionPeriod.getter(SuppressionPeriod::suppressionUnitAsString)).setter(SuppressionPeriod.setter(Builder::suppressionUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressionUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, SUPPRESSION_UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer value;
    private final String suppressionUnit;

    private SuppressionPeriod(BuilderImpl builder) {
        this.value = builder.value;
        this.suppressionUnit = builder.suppressionUnit;
    }

    public final Integer value() {
        return this.value;
    }

    public final SuppressionUnit suppressionUnit() {
        return SuppressionUnit.fromValue(this.suppressionUnit);
    }

    public final String suppressionUnitAsString() {
        return this.suppressionUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressionUnitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuppressionPeriod)) {
            return false;
        }
        SuppressionPeriod other = (SuppressionPeriod)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.suppressionUnitAsString(), other.suppressionUnitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SuppressionPeriod").add("Value", (Object)this.value()).add("SuppressionUnit", (Object)this.suppressionUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "suppressionUnit": {
                return Optional.ofNullable(clazz.cast(this.suppressionUnitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuppressionPeriod, T> g) {
        return obj -> g.apply((SuppressionPeriod)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer value;
        private String suppressionUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(SuppressionPeriod model) {
            this.value(model.value);
            this.suppressionUnit(model.suppressionUnit);
        }

        public final Integer getValue() {
            return this.value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final String getSuppressionUnit() {
            return this.suppressionUnit;
        }

        public final void setSuppressionUnit(String suppressionUnit) {
            this.suppressionUnit = suppressionUnit;
        }

        @Override
        public final Builder suppressionUnit(String suppressionUnit) {
            this.suppressionUnit = suppressionUnit;
            return this;
        }

        @Override
        public final Builder suppressionUnit(SuppressionUnit suppressionUnit) {
            this.suppressionUnit(suppressionUnit == null ? null : suppressionUnit.toString());
            return this;
        }

        public SuppressionPeriod build() {
            return new SuppressionPeriod(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuppressionPeriod> {
        public Builder value(Integer var1);

        public Builder suppressionUnit(String var1);

        public Builder suppressionUnit(SuppressionUnit var1);
    }
}

