/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.SuppressionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnomaliesRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, ListAnomaliesRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("anomalyDetectorArn").getter(ListAnomaliesRequest.getter(ListAnomaliesRequest::anomalyDetectorArn)).setter(ListAnomaliesRequest.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorArn").build()}).build();
    private static final SdkField<String> SUPPRESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suppressionState").getter(ListAnomaliesRequest.getter(ListAnomaliesRequest::suppressionStateAsString)).setter(ListAnomaliesRequest.setter(Builder::suppressionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressionState").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(ListAnomaliesRequest.getter(ListAnomaliesRequest::limit)).setter(ListAnomaliesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAnomaliesRequest.getter(ListAnomaliesRequest::nextToken)).setter(ListAnomaliesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD, SUPPRESSION_STATE_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final String anomalyDetectorArn;
    private final String suppressionState;
    private final Integer limit;
    private final String nextToken;

    private ListAnomaliesRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.suppressionState = builder.suppressionState;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final SuppressionState suppressionState() {
        return SuppressionState.fromValue(this.suppressionState);
    }

    public final String suppressionStateAsString() {
        return this.suppressionState;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomaliesRequest)) {
            return false;
        }
        ListAnomaliesRequest other = (ListAnomaliesRequest)((Object)obj);
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.suppressionStateAsString(), other.suppressionStateAsString()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnomaliesRequest").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("SuppressionState", (Object)this.suppressionStateAsString()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "anomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "suppressionState": {
                return Optional.ofNullable(clazz.cast(this.suppressionStateAsString()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomaliesRequest, T> g) {
        return obj -> g.apply((ListAnomaliesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;
        private String suppressionState;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomaliesRequest model) {
            super(model);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.suppressionState(model.suppressionState);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getSuppressionState() {
            return this.suppressionState;
        }

        public final void setSuppressionState(String suppressionState) {
            this.suppressionState = suppressionState;
        }

        @Override
        public final Builder suppressionState(String suppressionState) {
            this.suppressionState = suppressionState;
            return this;
        }

        @Override
        public final Builder suppressionState(SuppressionState suppressionState) {
            this.suppressionState(suppressionState == null ? null : suppressionState.toString());
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAnomaliesRequest build() {
            return new ListAnomaliesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnomaliesRequest> {
        public Builder anomalyDetectorArn(String var1);

        public Builder suppressionState(String var1);

        public Builder suppressionState(SuppressionState var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

