/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.Anomaly;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesResponse;

public class ListAnomaliesPublisher
implements SdkPublisher<ListAnomaliesResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final ListAnomaliesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnomaliesPublisher(CloudWatchLogsAsyncClient client, ListAnomaliesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnomaliesPublisher(CloudWatchLogsAsyncClient client, ListAnomaliesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnomaliesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnomaliesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Anomaly> anomalies() {
        Function<ListAnomaliesResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalies() != null) {
                return response.anomalies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnomaliesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAnomaliesResponseFetcher
    implements AsyncPageFetcher<ListAnomaliesResponse> {
        private ListAnomaliesResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomaliesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnomaliesResponse> nextPage(ListAnomaliesResponse previousPage) {
            if (previousPage == null) {
                return ListAnomaliesPublisher.this.client.listAnomalies(ListAnomaliesPublisher.this.firstRequest);
            }
            return ListAnomaliesPublisher.this.client.listAnomalies((ListAnomaliesRequest)((Object)ListAnomaliesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

