/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.Delivery;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesResponse;

public class DescribeDeliveriesPublisher
implements SdkPublisher<DescribeDeliveriesResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final DescribeDeliveriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDeliveriesPublisher(CloudWatchLogsAsyncClient client, DescribeDeliveriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDeliveriesPublisher(CloudWatchLogsAsyncClient client, DescribeDeliveriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDeliveriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDeliveriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Delivery> deliveries() {
        Function<DescribeDeliveriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.deliveries() != null) {
                return response.deliveries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDeliveriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDeliveriesResponseFetcher
    implements AsyncPageFetcher<DescribeDeliveriesResponse> {
        private DescribeDeliveriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDeliveriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeDeliveriesResponse> nextPage(DescribeDeliveriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDeliveriesPublisher.this.client.describeDeliveries(DescribeDeliveriesPublisher.this.firstRequest);
            }
            return DescribeDeliveriesPublisher.this.client.describeDeliveries((DescribeDeliveriesRequest)((Object)DescribeDeliveriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

