/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.AccountPolicy;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAccountPolicyResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, PutAccountPolicyResponse> {
    private static final SdkField<AccountPolicy> ACCOUNT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accountPolicy").getter(PutAccountPolicyResponse.getter(PutAccountPolicyResponse::accountPolicy)).setter(PutAccountPolicyResponse.setter(Builder::accountPolicy)).constructor(AccountPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_POLICY_FIELD));
    private final AccountPolicy accountPolicy;

    private PutAccountPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.accountPolicy = builder.accountPolicy;
    }

    public final AccountPolicy accountPolicy() {
        return this.accountPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountPolicyResponse)) {
            return false;
        }
        PutAccountPolicyResponse other = (PutAccountPolicyResponse)((Object)obj);
        return Objects.equals(this.accountPolicy(), other.accountPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutAccountPolicyResponse").add("AccountPolicy", (Object)this.accountPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountPolicy": {
                return Optional.ofNullable(clazz.cast(this.accountPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountPolicyResponse, T> g) {
        return obj -> g.apply((PutAccountPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private AccountPolicy accountPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountPolicyResponse model) {
            super(model);
            this.accountPolicy(model.accountPolicy);
        }

        public final AccountPolicy.Builder getAccountPolicy() {
            return this.accountPolicy != null ? this.accountPolicy.toBuilder() : null;
        }

        public final void setAccountPolicy(AccountPolicy.BuilderImpl accountPolicy) {
            this.accountPolicy = accountPolicy != null ? accountPolicy.build() : null;
        }

        @Override
        public final Builder accountPolicy(AccountPolicy accountPolicy) {
            this.accountPolicy = accountPolicy;
            return this;
        }

        @Override
        public PutAccountPolicyResponse build() {
            return new PutAccountPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAccountPolicyResponse> {
        public Builder accountPolicy(AccountPolicy var1);

        default public Builder accountPolicy(Consumer<AccountPolicy.Builder> accountPolicy) {
            return this.accountPolicy((AccountPolicy)((AccountPolicy.Builder)AccountPolicy.builder().applyMutation(accountPolicy)).build());
        }
    }
}

