/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.DataProtectionStatus;
import software.amazon.awssdk.services.cloudwatchlogs.model.InheritedPropertiesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.InheritedProperty;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogGroup> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(LogGroup.getter(LogGroup::logGroupName)).setter(LogGroup.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTime").getter(LogGroup.getter(LogGroup::creationTime)).setter(LogGroup.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Integer> RETENTION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionInDays").getter(LogGroup.getter(LogGroup::retentionInDays)).setter(LogGroup.setter(Builder::retentionInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionInDays").build()}).build();
    private static final SdkField<Integer> METRIC_FILTER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("metricFilterCount").getter(LogGroup.getter(LogGroup::metricFilterCount)).setter(LogGroup.setter(Builder::metricFilterCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricFilterCount").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LogGroup.getter(LogGroup::arn)).setter(LogGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Long> STORED_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storedBytes").getter(LogGroup.getter(LogGroup::storedBytes)).setter(LogGroup.setter(Builder::storedBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storedBytes").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(LogGroup.getter(LogGroup::kmsKeyId)).setter(LogGroup.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> DATA_PROTECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataProtectionStatus").getter(LogGroup.getter(LogGroup::dataProtectionStatusAsString)).setter(LogGroup.setter(Builder::dataProtectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProtectionStatus").build()}).build();
    private static final SdkField<List<String>> INHERITED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inheritedProperties").getter(LogGroup.getter(LogGroup::inheritedPropertiesAsStrings)).setter(LogGroup.setter(Builder::inheritedPropertiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inheritedProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, CREATION_TIME_FIELD, RETENTION_IN_DAYS_FIELD, METRIC_FILTER_COUNT_FIELD, ARN_FIELD, STORED_BYTES_FIELD, KMS_KEY_ID_FIELD, DATA_PROTECTION_STATUS_FIELD, INHERITED_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logGroupName;
    private final Long creationTime;
    private final Integer retentionInDays;
    private final Integer metricFilterCount;
    private final String arn;
    private final Long storedBytes;
    private final String kmsKeyId;
    private final String dataProtectionStatus;
    private final List<String> inheritedProperties;

    private LogGroup(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.creationTime = builder.creationTime;
        this.retentionInDays = builder.retentionInDays;
        this.metricFilterCount = builder.metricFilterCount;
        this.arn = builder.arn;
        this.storedBytes = builder.storedBytes;
        this.kmsKeyId = builder.kmsKeyId;
        this.dataProtectionStatus = builder.dataProtectionStatus;
        this.inheritedProperties = builder.inheritedProperties;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final Integer retentionInDays() {
        return this.retentionInDays;
    }

    public final Integer metricFilterCount() {
        return this.metricFilterCount;
    }

    public final String arn() {
        return this.arn;
    }

    public final Long storedBytes() {
        return this.storedBytes;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final DataProtectionStatus dataProtectionStatus() {
        return DataProtectionStatus.fromValue(this.dataProtectionStatus);
    }

    public final String dataProtectionStatusAsString() {
        return this.dataProtectionStatus;
    }

    public final List<InheritedProperty> inheritedProperties() {
        return InheritedPropertiesCopier.copyStringToEnum(this.inheritedProperties);
    }

    public final boolean hasInheritedProperties() {
        return this.inheritedProperties != null && !(this.inheritedProperties instanceof SdkAutoConstructList);
    }

    public final List<String> inheritedPropertiesAsStrings() {
        return this.inheritedProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricFilterCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.storedBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProtectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInheritedProperties() ? this.inheritedPropertiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogGroup)) {
            return false;
        }
        LogGroup other = (LogGroup)obj;
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.retentionInDays(), other.retentionInDays()) && Objects.equals(this.metricFilterCount(), other.metricFilterCount()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.storedBytes(), other.storedBytes()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dataProtectionStatusAsString(), other.dataProtectionStatusAsString()) && this.hasInheritedProperties() == other.hasInheritedProperties() && Objects.equals(this.inheritedPropertiesAsStrings(), other.inheritedPropertiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"LogGroup").add("LogGroupName", (Object)this.logGroupName()).add("CreationTime", (Object)this.creationTime()).add("RetentionInDays", (Object)this.retentionInDays()).add("MetricFilterCount", (Object)this.metricFilterCount()).add("Arn", (Object)this.arn()).add("StoredBytes", (Object)this.storedBytes()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DataProtectionStatus", (Object)this.dataProtectionStatusAsString()).add("InheritedProperties", this.hasInheritedProperties() ? this.inheritedPropertiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "retentionInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionInDays()));
            }
            case "metricFilterCount": {
                return Optional.ofNullable(clazz.cast(this.metricFilterCount()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "storedBytes": {
                return Optional.ofNullable(clazz.cast(this.storedBytes()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "dataProtectionStatus": {
                return Optional.ofNullable(clazz.cast(this.dataProtectionStatusAsString()));
            }
            case "inheritedProperties": {
                return Optional.ofNullable(clazz.cast(this.inheritedPropertiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogGroup, T> g) {
        return obj -> g.apply((LogGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private Long creationTime;
        private Integer retentionInDays;
        private Integer metricFilterCount;
        private String arn;
        private Long storedBytes;
        private String kmsKeyId;
        private String dataProtectionStatus;
        private List<String> inheritedProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogGroup model) {
            this.logGroupName(model.logGroupName);
            this.creationTime(model.creationTime);
            this.retentionInDays(model.retentionInDays);
            this.metricFilterCount(model.metricFilterCount);
            this.arn(model.arn);
            this.storedBytes(model.storedBytes);
            this.kmsKeyId(model.kmsKeyId);
            this.dataProtectionStatus(model.dataProtectionStatus);
            this.inheritedPropertiesWithStrings(model.inheritedProperties);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getRetentionInDays() {
            return this.retentionInDays;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final Integer getMetricFilterCount() {
            return this.metricFilterCount;
        }

        public final void setMetricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
        }

        @Override
        public final Builder metricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getStoredBytes() {
            return this.storedBytes;
        }

        public final void setStoredBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
        }

        @Override
        public final Builder storedBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDataProtectionStatus() {
            return this.dataProtectionStatus;
        }

        public final void setDataProtectionStatus(String dataProtectionStatus) {
            this.dataProtectionStatus = dataProtectionStatus;
        }

        @Override
        public final Builder dataProtectionStatus(String dataProtectionStatus) {
            this.dataProtectionStatus = dataProtectionStatus;
            return this;
        }

        @Override
        public final Builder dataProtectionStatus(DataProtectionStatus dataProtectionStatus) {
            this.dataProtectionStatus(dataProtectionStatus == null ? null : dataProtectionStatus.toString());
            return this;
        }

        public final Collection<String> getInheritedProperties() {
            if (this.inheritedProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inheritedProperties;
        }

        public final void setInheritedProperties(Collection<String> inheritedProperties) {
            this.inheritedProperties = InheritedPropertiesCopier.copy(inheritedProperties);
        }

        @Override
        public final Builder inheritedPropertiesWithStrings(Collection<String> inheritedProperties) {
            this.inheritedProperties = InheritedPropertiesCopier.copy(inheritedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inheritedPropertiesWithStrings(String ... inheritedProperties) {
            this.inheritedPropertiesWithStrings(Arrays.asList(inheritedProperties));
            return this;
        }

        @Override
        public final Builder inheritedProperties(Collection<InheritedProperty> inheritedProperties) {
            this.inheritedProperties = InheritedPropertiesCopier.copyEnumToString(inheritedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inheritedProperties(InheritedProperty ... inheritedProperties) {
            this.inheritedProperties(Arrays.asList(inheritedProperties));
            return this;
        }

        public LogGroup build() {
            return new LogGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogGroup> {
        public Builder logGroupName(String var1);

        public Builder creationTime(Long var1);

        public Builder retentionInDays(Integer var1);

        public Builder metricFilterCount(Integer var1);

        public Builder arn(String var1);

        public Builder storedBytes(Long var1);

        public Builder kmsKeyId(String var1);

        public Builder dataProtectionStatus(String var1);

        public Builder dataProtectionStatus(DataProtectionStatus var1);

        public Builder inheritedPropertiesWithStrings(Collection<String> var1);

        public Builder inheritedPropertiesWithStrings(String ... var1);

        public Builder inheritedProperties(Collection<InheritedProperty> var1);

        public Builder inheritedProperties(InheritedProperty ... var1);
    }
}

