/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.Destination;

public class DescribeDestinationsIterable
implements SdkIterable<DescribeDestinationsResponse> {
    private final CloudWatchLogsClient client;
    private final DescribeDestinationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDestinationsIterable(CloudWatchLogsClient client, DescribeDestinationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDestinationsResponseFetcher();
    }

    public Iterator<DescribeDestinationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Destination> destinations() {
        Function<DescribeDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.destinations() != null) {
                return response.destinations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDestinationsResponseFetcher
    implements SyncPageFetcher<DescribeDestinationsResponse> {
        private DescribeDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDestinationsResponse nextPage(DescribeDestinationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDestinationsIterable.this.client.describeDestinations(DescribeDestinationsIterable.this.firstRequest);
            }
            return DescribeDestinationsIterable.this.client.describeDestinations((DescribeDestinationsRequest)((Object)DescribeDestinationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

