/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilteredLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.SearchedLogStream;

public class FilterLogEventsIterable
implements SdkIterable<FilterLogEventsResponse> {
    private final CloudWatchLogsClient client;
    private final FilterLogEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public FilterLogEventsIterable(CloudWatchLogsClient client, FilterLogEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new FilterLogEventsResponseFetcher();
    }

    public Iterator<FilterLogEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FilteredLogEvent> events() {
        Function<FilterLogEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<SearchedLogStream> searchedLogStreams() {
        Function<FilterLogEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.searchedLogStreams() != null) {
                return response.searchedLogStreams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class FilterLogEventsResponseFetcher
    implements SyncPageFetcher<FilterLogEventsResponse> {
        private FilterLogEventsResponseFetcher() {
        }

        public boolean hasNextPage(FilterLogEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public FilterLogEventsResponse nextPage(FilterLogEventsResponse previousPage) {
            if (previousPage == null) {
                return FilterLogEventsIterable.this.client.filterLogEvents(FilterLogEventsIterable.this.firstRequest);
            }
            return FilterLogEventsIterable.this.client.filterLogEvents((FilterLogEventsRequest)((Object)FilterLogEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

