/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformation;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricFilter> {
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterName").getter(MetricFilter.getter(MetricFilter::filterName)).setter(MetricFilter.setter(Builder::filterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPattern").getter(MetricFilter.getter(MetricFilter::filterPattern)).setter(MetricFilter.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<List<MetricTransformation>> METRIC_TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricTransformations").getter(MetricFilter.getter(MetricFilter::metricTransformations)).setter(MetricFilter.setter(Builder::metricTransformations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricTransformations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricTransformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTime").getter(MetricFilter.getter(MetricFilter::creationTime)).setter(MetricFilter.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(MetricFilter.getter(MetricFilter::logGroupName)).setter(MetricFilter.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_NAME_FIELD, FILTER_PATTERN_FIELD, METRIC_TRANSFORMATIONS_FIELD, CREATION_TIME_FIELD, LOG_GROUP_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filterName;
    private final String filterPattern;
    private final List<MetricTransformation> metricTransformations;
    private final Long creationTime;
    private final String logGroupName;

    private MetricFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.metricTransformations = builder.metricTransformations;
        this.creationTime = builder.creationTime;
        this.logGroupName = builder.logGroupName;
    }

    public final String filterName() {
        return this.filterName;
    }

    public final String filterPattern() {
        return this.filterPattern;
    }

    public final boolean hasMetricTransformations() {
        return this.metricTransformations != null && !(this.metricTransformations instanceof SdkAutoConstructList);
    }

    public final List<MetricTransformation> metricTransformations() {
        return this.metricTransformations;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricTransformations() ? this.metricTransformations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilter)) {
            return false;
        }
        MetricFilter other = (MetricFilter)obj;
        return Objects.equals(this.filterName(), other.filterName()) && Objects.equals(this.filterPattern(), other.filterPattern()) && this.hasMetricTransformations() == other.hasMetricTransformations() && Objects.equals(this.metricTransformations(), other.metricTransformations()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.logGroupName(), other.logGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"MetricFilter").add("FilterName", (Object)this.filterName()).add("FilterPattern", (Object)this.filterPattern()).add("MetricTransformations", this.hasMetricTransformations() ? this.metricTransformations() : null).add("CreationTime", (Object)this.creationTime()).add("LogGroupName", (Object)this.logGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterName": {
                return Optional.ofNullable(clazz.cast(this.filterName()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "metricTransformations": {
                return Optional.ofNullable(clazz.cast(this.metricTransformations()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricFilter, T> g) {
        return obj -> g.apply((MetricFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterName;
        private String filterPattern;
        private List<MetricTransformation> metricTransformations = DefaultSdkAutoConstructList.getInstance();
        private Long creationTime;
        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricFilter model) {
            this.filterName(model.filterName);
            this.filterPattern(model.filterPattern);
            this.metricTransformations(model.metricTransformations);
            this.creationTime(model.creationTime);
            this.logGroupName(model.logGroupName);
        }

        public final String getFilterName() {
            return this.filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final Collection<MetricTransformation.Builder> getMetricTransformations() {
            if (this.metricTransformations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricTransformations != null ? (Collection)this.metricTransformations.stream().map(MetricTransformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricTransformations(Collection<MetricTransformation> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copy(metricTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(MetricTransformation ... metricTransformations) {
            this.metricTransformations(Arrays.asList(metricTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(Consumer<MetricTransformation.Builder> ... metricTransformations) {
            this.metricTransformations(Stream.of(metricTransformations).map(c -> (MetricTransformation)((MetricTransformation.Builder)MetricTransformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricTransformations(Collection<MetricTransformation.BuilderImpl> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copyFromBuilder(metricTransformations);
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public MetricFilter build() {
            return new MetricFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricFilter> {
        public Builder filterName(String var1);

        public Builder filterPattern(String var1);

        public Builder metricTransformations(Collection<MetricTransformation> var1);

        public Builder metricTransformations(MetricTransformation ... var1);

        public Builder metricTransformations(Consumer<MetricTransformation.Builder> ... var1);

        public Builder creationTime(Long var1);

        public Builder logGroupName(String var1);
    }
}

