/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogGroup> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(LogGroup.getter(LogGroup::logGroupName)).setter(LogGroup.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTime").getter(LogGroup.getter(LogGroup::creationTime)).setter(LogGroup.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Integer> RETENTION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionInDays").getter(LogGroup.getter(LogGroup::retentionInDays)).setter(LogGroup.setter(Builder::retentionInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionInDays").build()}).build();
    private static final SdkField<Integer> METRIC_FILTER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("metricFilterCount").getter(LogGroup.getter(LogGroup::metricFilterCount)).setter(LogGroup.setter(Builder::metricFilterCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricFilterCount").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LogGroup.getter(LogGroup::arn)).setter(LogGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Long> STORED_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storedBytes").getter(LogGroup.getter(LogGroup::storedBytes)).setter(LogGroup.setter(Builder::storedBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storedBytes").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(LogGroup.getter(LogGroup::kmsKeyId)).setter(LogGroup.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, CREATION_TIME_FIELD, RETENTION_IN_DAYS_FIELD, METRIC_FILTER_COUNT_FIELD, ARN_FIELD, STORED_BYTES_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logGroupName;
    private final Long creationTime;
    private final Integer retentionInDays;
    private final Integer metricFilterCount;
    private final String arn;
    private final Long storedBytes;
    private final String kmsKeyId;

    private LogGroup(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.creationTime = builder.creationTime;
        this.retentionInDays = builder.retentionInDays;
        this.metricFilterCount = builder.metricFilterCount;
        this.arn = builder.arn;
        this.storedBytes = builder.storedBytes;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    public Integer metricFilterCount() {
        return this.metricFilterCount;
    }

    public String arn() {
        return this.arn;
    }

    public Long storedBytes() {
        return this.storedBytes;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricFilterCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.storedBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogGroup)) {
            return false;
        }
        LogGroup other = (LogGroup)obj;
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.retentionInDays(), other.retentionInDays()) && Objects.equals(this.metricFilterCount(), other.metricFilterCount()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.storedBytes(), other.storedBytes()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"LogGroup").add("LogGroupName", (Object)this.logGroupName()).add("CreationTime", (Object)this.creationTime()).add("RetentionInDays", (Object)this.retentionInDays()).add("MetricFilterCount", (Object)this.metricFilterCount()).add("Arn", (Object)this.arn()).add("StoredBytes", (Object)this.storedBytes()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "retentionInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionInDays()));
            }
            case "metricFilterCount": {
                return Optional.ofNullable(clazz.cast(this.metricFilterCount()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "storedBytes": {
                return Optional.ofNullable(clazz.cast(this.storedBytes()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogGroup, T> g) {
        return obj -> g.apply((LogGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private Long creationTime;
        private Integer retentionInDays;
        private Integer metricFilterCount;
        private String arn;
        private Long storedBytes;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(LogGroup model) {
            this.logGroupName(model.logGroupName);
            this.creationTime(model.creationTime);
            this.retentionInDays(model.retentionInDays);
            this.metricFilterCount(model.metricFilterCount);
            this.arn(model.arn);
            this.storedBytes(model.storedBytes);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final Integer getRetentionInDays() {
            return this.retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        public final Integer getMetricFilterCount() {
            return this.metricFilterCount;
        }

        @Override
        public final Builder metricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
            return this;
        }

        public final void setMetricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getStoredBytes() {
            return this.storedBytes;
        }

        @Override
        public final Builder storedBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
            return this;
        }

        public final void setStoredBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public LogGroup build() {
            return new LogGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogGroup> {
        public Builder logGroupName(String var1);

        public Builder creationTime(Long var1);

        public Builder retentionInDays(Integer var1);

        public Builder metricFilterCount(Integer var1);

        public Builder arn(String var1);

        public Builder storedBytes(Long var1);

        public Builder kmsKeyId(String var1);
    }
}

