/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchedLogStream
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchedLogStream> {
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStreamName").getter(SearchedLogStream.getter(SearchedLogStream::logStreamName)).setter(SearchedLogStream.setter(Builder::logStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()}).build();
    private static final SdkField<Boolean> SEARCHED_COMPLETELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("searchedCompletely").getter(SearchedLogStream.getter(SearchedLogStream::searchedCompletely)).setter(SearchedLogStream.setter(Builder::searchedCompletely)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchedCompletely").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAM_NAME_FIELD, SEARCHED_COMPLETELY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logStreamName;
    private final Boolean searchedCompletely;

    private SearchedLogStream(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.searchedCompletely = builder.searchedCompletely;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Boolean searchedCompletely() {
        return this.searchedCompletely;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedCompletely());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchedLogStream)) {
            return false;
        }
        SearchedLogStream other = (SearchedLogStream)obj;
        return Objects.equals(this.logStreamName(), other.logStreamName()) && Objects.equals(this.searchedCompletely(), other.searchedCompletely());
    }

    public String toString() {
        return ToString.builder((String)"SearchedLogStream").add("LogStreamName", (Object)this.logStreamName()).add("SearchedCompletely", (Object)this.searchedCompletely()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
            case "searchedCompletely": {
                return Optional.ofNullable(clazz.cast(this.searchedCompletely()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchedLogStream, T> g) {
        return obj -> g.apply((SearchedLogStream)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logStreamName;
        private Boolean searchedCompletely;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchedLogStream model) {
            this.logStreamName(model.logStreamName);
            this.searchedCompletely(model.searchedCompletely);
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Boolean getSearchedCompletely() {
            return this.searchedCompletely;
        }

        @Override
        public final Builder searchedCompletely(Boolean searchedCompletely) {
            this.searchedCompletely = searchedCompletely;
            return this;
        }

        public final void setSearchedCompletely(Boolean searchedCompletely) {
            this.searchedCompletely = searchedCompletely;
        }

        public SearchedLogStream build() {
            return new SearchedLogStream(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchedLogStream> {
        public Builder logStreamName(String var1);

        public Builder searchedCompletely(Boolean var1);
    }
}

