/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.Destination;

public class DescribeDestinationsPublisher
implements SdkPublisher<DescribeDestinationsResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final DescribeDestinationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDestinationsPublisher(CloudWatchLogsAsyncClient client, DescribeDestinationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDestinationsPublisher(CloudWatchLogsAsyncClient client, DescribeDestinationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDestinationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDestinationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Destination> destinations() {
        Function<DescribeDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.destinations() != null) {
                return response.destinations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDestinationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDestinationsResponseFetcher
    implements AsyncPageFetcher<DescribeDestinationsResponse> {
        private DescribeDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeDestinationsResponse> nextPage(DescribeDestinationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDestinationsPublisher.this.client.describeDestinations(DescribeDestinationsPublisher.this.firstRequest);
            }
            return DescribeDestinationsPublisher.this.client.describeDestinations((DescribeDestinationsRequest)((Object)DescribeDestinationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

