/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLogGroupsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeLogGroupsResponse> {
    private static final SdkField<List<LogGroup>> LOG_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeLogGroupsResponse.getter(DescribeLogGroupsResponse::logGroups)).setter(DescribeLogGroupsResponse.setter(Builder::logGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLogGroupsResponse.getter(DescribeLogGroupsResponse::nextToken)).setter(DescribeLogGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<LogGroup> logGroups;
    private final String nextToken;

    private DescribeLogGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.logGroups = builder.logGroups;
        this.nextToken = builder.nextToken;
    }

    public boolean hasLogGroups() {
        return this.logGroups != null && !(this.logGroups instanceof SdkAutoConstructList);
    }

    public List<LogGroup> logGroups() {
        return this.logGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogGroupsResponse)) {
            return false;
        }
        DescribeLogGroupsResponse other = (DescribeLogGroupsResponse)((Object)obj);
        return Objects.equals(this.logGroups(), other.logGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLogGroupsResponse").add("LogGroups", this.logGroups()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroups": {
                return Optional.ofNullable(clazz.cast(this.logGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLogGroupsResponse, T> g) {
        return obj -> g.apply((DescribeLogGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<LogGroup> logGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogGroupsResponse model) {
            super(model);
            this.logGroups(model.logGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<LogGroup.Builder> getLogGroups() {
            return this.logGroups != null ? (Collection)this.logGroups.stream().map(LogGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder logGroups(Collection<LogGroup> logGroups) {
            this.logGroups = LogGroupsCopier.copy(logGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(LogGroup ... logGroups) {
            this.logGroups(Arrays.asList(logGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(Consumer<LogGroup.Builder> ... logGroups) {
            this.logGroups(Stream.of(logGroups).map(c -> (LogGroup)((LogGroup.Builder)LogGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLogGroups(Collection<LogGroup.BuilderImpl> logGroups) {
            this.logGroups = LogGroupsCopier.copyFromBuilder(logGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLogGroupsResponse build() {
            return new DescribeLogGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLogGroupsResponse> {
        public Builder logGroups(Collection<LogGroup> var1);

        public Builder logGroups(LogGroup ... var1);

        public Builder logGroups(Consumer<LogGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

