/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.EventSource;
import software.amazon.awssdk.services.cloudwatchevents.model.EventSourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventSourcesResponse
extends CloudWatchEventsResponse
implements ToCopyableBuilder<Builder, ListEventSourcesResponse> {
    private static final SdkField<List<EventSource>> EVENT_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListEventSourcesResponse.getter(ListEventSourcesResponse::eventSources)).setter(ListEventSourcesResponse.setter(Builder::eventSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListEventSourcesResponse.getter(ListEventSourcesResponse::nextToken)).setter(ListEventSourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<EventSource> eventSources;
    private final String nextToken;

    private ListEventSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.eventSources = builder.eventSources;
        this.nextToken = builder.nextToken;
    }

    public List<EventSource> eventSources() {
        return this.eventSources;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventSourcesResponse)) {
            return false;
        }
        ListEventSourcesResponse other = (ListEventSourcesResponse)((Object)obj);
        return Objects.equals(this.eventSources(), other.eventSources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListEventSourcesResponse").add("EventSources", this.eventSources()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventSources": {
                return Optional.ofNullable(clazz.cast(this.eventSources()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventSourcesResponse, T> g) {
        return obj -> g.apply((ListEventSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsResponse.BuilderImpl
    implements Builder {
        private List<EventSource> eventSources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventSourcesResponse model) {
            super(model);
            this.eventSources(model.eventSources);
            this.nextToken(model.nextToken);
        }

        public final Collection<EventSource.Builder> getEventSources() {
            return this.eventSources != null ? (Collection)this.eventSources.stream().map(EventSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventSources(Collection<EventSource> eventSources) {
            this.eventSources = EventSourceListCopier.copy(eventSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSources(EventSource ... eventSources) {
            this.eventSources(Arrays.asList(eventSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSources(Consumer<EventSource.Builder> ... eventSources) {
            this.eventSources(Stream.of(eventSources).map(c -> (EventSource)((EventSource.Builder)EventSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventSources(Collection<EventSource.BuilderImpl> eventSources) {
            this.eventSources = EventSourceListCopier.copyFromBuilder(eventSources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEventSourcesResponse build() {
            return new ListEventSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventSourcesResponse> {
        public Builder eventSources(Collection<EventSource> var1);

        public Builder eventSources(EventSource ... var1);

        public Builder eventSources(Consumer<EventSource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

