/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchException;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudwatch.model.DashboardInvalidInputErrorException;
import software.amazon.awssdk.services.cloudwatch.model.DashboardNotFoundErrorException;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse;
import software.amazon.awssdk.services.cloudwatch.model.InternalServiceException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidFormatException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidNextTokenException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidParameterValueException;
import software.amazon.awssdk.services.cloudwatch.model.LimitExceededException;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudwatch.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.cloudwatch.model.PutAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateResponse;
import software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudwatch.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudwatch.paginators.DescribeAlarmHistoryIterable;
import software.amazon.awssdk.services.cloudwatch.paginators.DescribeAlarmsIterable;
import software.amazon.awssdk.services.cloudwatch.paginators.GetMetricDataIterable;
import software.amazon.awssdk.services.cloudwatch.paginators.ListDashboardsIterable;
import software.amazon.awssdk.services.cloudwatch.paginators.ListMetricsIterable;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteAlarmsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteDashboardsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmHistoryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsForMetricRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAnomalyDetectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DisableAlarmActionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.EnableAlarmActionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricStatisticsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricWidgetImageRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListMetricsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricAlarmRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.SetAlarmStateRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.UntagResourceRequestMarshaller;

@SdkInternalApi
final class DefaultCloudWatchClient
implements CloudWatchClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudWatchClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "monitoring";
    }

    @Override
    public DeleteAlarmsResponse deleteAlarms(DeleteAlarmsRequest deleteAlarmsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteAlarmsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteAlarmsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlarms").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAlarmsRequest).withMarshaller((Marshaller)new DeleteAlarmsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteAnomalyDetectorResponse deleteAnomalyDetector(DeleteAnomalyDetectorRequest deleteAnomalyDetectorRequest) throws ResourceNotFoundException, InternalServiceException, InvalidParameterValueException, MissingRequiredParameterException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteAnomalyDetectorResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteAnomalyDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnomalyDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAnomalyDetectorRequest).withMarshaller((Marshaller)new DeleteAnomalyDetectorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDashboardsResponse deleteDashboards(DeleteDashboardsRequest deleteDashboardsRequest) throws InvalidParameterValueException, DashboardNotFoundErrorException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDashboardsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDashboardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDashboards").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDashboardsRequest).withMarshaller((Marshaller)new DeleteDashboardsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAlarmHistoryResponse describeAlarmHistory(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAlarmHistoryResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAlarmHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarmHistory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAlarmHistoryRequest).withMarshaller((Marshaller)new DescribeAlarmHistoryRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAlarmHistoryIterable describeAlarmHistoryPaginator(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, CloudWatchException {
        return new DescribeAlarmHistoryIterable(this, this.applyPaginatorUserAgent(describeAlarmHistoryRequest));
    }

    @Override
    public DescribeAlarmsResponse describeAlarms(DescribeAlarmsRequest describeAlarmsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAlarmsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAlarmsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarms").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAlarmsRequest).withMarshaller((Marshaller)new DescribeAlarmsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAlarmsIterable describeAlarmsPaginator(DescribeAlarmsRequest describeAlarmsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, CloudWatchException {
        return new DescribeAlarmsIterable(this, this.applyPaginatorUserAgent(describeAlarmsRequest));
    }

    @Override
    public DescribeAlarmsForMetricResponse describeAlarmsForMetric(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) throws AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAlarmsForMetricResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAlarmsForMetricResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarmsForMetric").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAlarmsForMetricRequest).withMarshaller((Marshaller)new DescribeAlarmsForMetricRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAnomalyDetectorsResponse describeAnomalyDetectors(DescribeAnomalyDetectorsRequest describeAnomalyDetectorsRequest) throws InvalidNextTokenException, InternalServiceException, InvalidParameterValueException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAnomalyDetectorsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAnomalyDetectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAnomalyDetectors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAnomalyDetectorsRequest).withMarshaller((Marshaller)new DescribeAnomalyDetectorsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisableAlarmActionsResponse disableAlarmActions(DisableAlarmActionsRequest disableAlarmActionsRequest) throws AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableAlarmActionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DisableAlarmActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAlarmActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableAlarmActionsRequest).withMarshaller((Marshaller)new DisableAlarmActionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EnableAlarmActionsResponse enableAlarmActions(EnableAlarmActionsRequest enableAlarmActionsRequest) throws AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableAlarmActionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (EnableAlarmActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAlarmActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableAlarmActionsRequest).withMarshaller((Marshaller)new EnableAlarmActionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetDashboardResponse getDashboard(GetDashboardRequest getDashboardRequest) throws InvalidParameterValueException, DashboardNotFoundErrorException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetDashboardResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetDashboardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDashboard").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDashboardRequest).withMarshaller((Marshaller)new GetDashboardRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetMetricDataResponse getMetricData(GetMetricDataRequest getMetricDataRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetMetricDataResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricData").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMetricDataRequest).withMarshaller((Marshaller)new GetMetricDataRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetMetricDataIterable getMetricDataPaginator(GetMetricDataRequest getMetricDataRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, CloudWatchException {
        return new GetMetricDataIterable(this, this.applyPaginatorUserAgent(getMetricDataRequest));
    }

    @Override
    public GetMetricStatisticsResponse getMetricStatistics(GetMetricStatisticsRequest getMetricStatisticsRequest) throws InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetMetricStatisticsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetMetricStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMetricStatisticsRequest).withMarshaller((Marshaller)new GetMetricStatisticsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetMetricWidgetImageResponse getMetricWidgetImage(GetMetricWidgetImageRequest getMetricWidgetImageRequest) throws AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetMetricWidgetImageResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetMetricWidgetImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricWidgetImage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMetricWidgetImageRequest).withMarshaller((Marshaller)new GetMetricWidgetImageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDashboardsResponse listDashboards(ListDashboardsRequest listDashboardsRequest) throws InvalidParameterValueException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListDashboardsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListDashboardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDashboards").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDashboardsRequest).withMarshaller((Marshaller)new ListDashboardsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDashboardsIterable listDashboardsPaginator(ListDashboardsRequest listDashboardsRequest) throws InvalidParameterValueException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        return new ListDashboardsIterable(this, this.applyPaginatorUserAgent(listDashboardsRequest));
    }

    @Override
    public ListMetricsResponse listMetrics(ListMetricsRequest listMetricsRequest) throws InternalServiceException, InvalidParameterValueException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListMetricsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListMetricsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMetrics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMetricsRequest).withMarshaller((Marshaller)new ListMetricsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListMetricsIterable listMetricsPaginator(ListMetricsRequest listMetricsRequest) throws InternalServiceException, InvalidParameterValueException, AwsServiceException, SdkClientException, CloudWatchException {
        return new ListMetricsIterable(this, this.applyPaginatorUserAgent(listMetricsRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidParameterValueException, ResourceNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutAnomalyDetectorResponse putAnomalyDetector(PutAnomalyDetectorRequest putAnomalyDetectorRequest) throws LimitExceededException, InternalServiceException, InvalidParameterValueException, MissingRequiredParameterException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutAnomalyDetectorResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PutAnomalyDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAnomalyDetector").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAnomalyDetectorRequest).withMarshaller((Marshaller)new PutAnomalyDetectorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutDashboardResponse putDashboard(PutDashboardRequest putDashboardRequest) throws DashboardInvalidInputErrorException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutDashboardResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PutDashboardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDashboard").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDashboardRequest).withMarshaller((Marshaller)new PutDashboardRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutMetricAlarmResponse putMetricAlarm(PutMetricAlarmRequest putMetricAlarmRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutMetricAlarmResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PutMetricAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMetricAlarm").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putMetricAlarmRequest).withMarshaller((Marshaller)new PutMetricAlarmRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutMetricDataResponse putMetricData(PutMetricDataRequest putMetricDataRequest) throws InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutMetricDataResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PutMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMetricData").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putMetricDataRequest).withMarshaller((Marshaller)new PutMetricDataRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetAlarmStateResponse setAlarmState(SetAlarmStateRequest setAlarmStateRequest) throws ResourceNotFoundException, InvalidFormatException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetAlarmStateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetAlarmStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetAlarmState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setAlarmStateRequest).withMarshaller((Marshaller)new SetAlarmStateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterValueException, ResourceNotFoundException, ConcurrentModificationException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TagResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterValueException, ResourceNotFoundException, ConcurrentModificationException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UntagResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValue").exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterCombination").exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFormat").exceptionBuilderSupplier(InvalidFormatException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingParameter").exceptionBuilderSupplier(MissingRequiredParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFound").exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterInput").exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceError").exceptionBuilderSupplier(InternalServiceException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextToken").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceeded").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudWatchException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CloudWatchRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.8.7").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudWatchRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

