/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.waiters;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetAlarmMuteRuleRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetAlarmMuteRuleResponse;
import software.amazon.awssdk.services.cloudwatch.waiters.CloudWatchWaiter;
import software.amazon.awssdk.services.cloudwatch.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultCloudWatchWaiter
implements CloudWatchWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final CloudWatchClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeAlarmsResponse> alarmExistsWaiter;
    private final Waiter<GetAlarmMuteRuleResponse> alarmMuteRuleExistsWaiter;
    private final Waiter<DescribeAlarmsResponse> compositeAlarmExistsWaiter;

    private DefaultCloudWatchWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (CloudWatchClient)CloudWatchClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.alarmExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeAlarmsResponse.class).acceptors(DefaultCloudWatchWaiter.alarmExistsWaiterAcceptors())).overrideConfiguration(DefaultCloudWatchWaiter.alarmExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.alarmMuteRuleExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetAlarmMuteRuleResponse.class).acceptors(DefaultCloudWatchWaiter.alarmMuteRuleExistsWaiterAcceptors())).overrideConfiguration(DefaultCloudWatchWaiter.alarmMuteRuleExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.compositeAlarmExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeAlarmsResponse.class).acceptors(DefaultCloudWatchWaiter.compositeAlarmExistsWaiterAcceptors())).overrideConfiguration(DefaultCloudWatchWaiter.compositeAlarmExistsWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeAlarmsResponse> waitUntilAlarmExists(DescribeAlarmsRequest describeAlarmsRequest) {
        return this.alarmExistsWaiter.run(() -> this.client.describeAlarms(this.applyWaitersUserAgent(describeAlarmsRequest)));
    }

    @Override
    public WaiterResponse<DescribeAlarmsResponse> waitUntilAlarmExists(DescribeAlarmsRequest describeAlarmsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.alarmExistsWaiter.run(() -> this.client.describeAlarms(this.applyWaitersUserAgent(describeAlarmsRequest)), DefaultCloudWatchWaiter.alarmExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetAlarmMuteRuleResponse> waitUntilAlarmMuteRuleExists(GetAlarmMuteRuleRequest getAlarmMuteRuleRequest) {
        return this.alarmMuteRuleExistsWaiter.run(() -> this.client.getAlarmMuteRule(this.applyWaitersUserAgent(getAlarmMuteRuleRequest)));
    }

    @Override
    public WaiterResponse<GetAlarmMuteRuleResponse> waitUntilAlarmMuteRuleExists(GetAlarmMuteRuleRequest getAlarmMuteRuleRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.alarmMuteRuleExistsWaiter.run(() -> this.client.getAlarmMuteRule(this.applyWaitersUserAgent(getAlarmMuteRuleRequest)), DefaultCloudWatchWaiter.alarmMuteRuleExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeAlarmsResponse> waitUntilCompositeAlarmExists(DescribeAlarmsRequest describeAlarmsRequest) {
        return this.compositeAlarmExistsWaiter.run(() -> this.client.describeAlarms(this.applyWaitersUserAgent(describeAlarmsRequest)));
    }

    @Override
    public WaiterResponse<DescribeAlarmsResponse> waitUntilCompositeAlarmExists(DescribeAlarmsRequest describeAlarmsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.compositeAlarmExistsWaiter.run(() -> this.client.describeAlarms(this.applyWaitersUserAgent(describeAlarmsRequest)), DefaultCloudWatchWaiter.compositeAlarmExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeAlarmsResponse>> alarmExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAlarmsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAlarmsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MetricAlarms").flatten().length().compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAlarmMuteRuleResponse>> alarmMuteRuleExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetAlarmMuteRuleResponse>> result = new ArrayList<WaiterAcceptor<? super GetAlarmMuteRuleResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAlarmsResponse>> compositeAlarmExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAlarmsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAlarmsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("CompositeAlarms").flatten().length().compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration alarmExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration alarmMuteRuleExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration compositeAlarmExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static CloudWatchWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends CloudWatchRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudWatchRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements CloudWatchWaiter.Builder {
        private CloudWatchClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public CloudWatchWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public CloudWatchWaiter.Builder client(CloudWatchClient client) {
            this.client = client;
            return this;
        }

        @Override
        public CloudWatchWaiter build() {
            return new DefaultCloudWatchWaiter(this);
        }
    }
}

