/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.waiters;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetAlarmMuteRuleRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetAlarmMuteRuleResponse;
import software.amazon.awssdk.services.cloudwatch.waiters.CloudWatchAsyncWaiter;
import software.amazon.awssdk.services.cloudwatch.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultCloudWatchAsyncWaiter
implements CloudWatchAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final CloudWatchAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeAlarmsResponse> alarmExistsWaiter;
    private final AsyncWaiter<GetAlarmMuteRuleResponse> alarmMuteRuleExistsWaiter;
    private final AsyncWaiter<DescribeAlarmsResponse> compositeAlarmExistsWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultCloudWatchAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (CloudWatchAsyncClient)CloudWatchAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.alarmExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeAlarmsResponse.class).acceptors(DefaultCloudWatchAsyncWaiter.alarmExistsWaiterAcceptors())).overrideConfiguration(DefaultCloudWatchAsyncWaiter.alarmExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.alarmMuteRuleExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetAlarmMuteRuleResponse.class).acceptors(DefaultCloudWatchAsyncWaiter.alarmMuteRuleExistsWaiterAcceptors())).overrideConfiguration(DefaultCloudWatchAsyncWaiter.alarmMuteRuleExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.compositeAlarmExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeAlarmsResponse.class).acceptors(DefaultCloudWatchAsyncWaiter.compositeAlarmExistsWaiterAcceptors())).overrideConfiguration(DefaultCloudWatchAsyncWaiter.compositeAlarmExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilAlarmExists(DescribeAlarmsRequest describeAlarmsRequest) {
        return this.alarmExistsWaiter.runAsync(() -> this.client.describeAlarms(this.applyWaitersUserAgent(describeAlarmsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilAlarmExists(DescribeAlarmsRequest describeAlarmsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.alarmExistsWaiter.runAsync(() -> this.client.describeAlarms(this.applyWaitersUserAgent(describeAlarmsRequest)), DefaultCloudWatchAsyncWaiter.alarmExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAlarmMuteRuleResponse>> waitUntilAlarmMuteRuleExists(GetAlarmMuteRuleRequest getAlarmMuteRuleRequest) {
        return this.alarmMuteRuleExistsWaiter.runAsync(() -> this.client.getAlarmMuteRule(this.applyWaitersUserAgent(getAlarmMuteRuleRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAlarmMuteRuleResponse>> waitUntilAlarmMuteRuleExists(GetAlarmMuteRuleRequest getAlarmMuteRuleRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.alarmMuteRuleExistsWaiter.runAsync(() -> this.client.getAlarmMuteRule(this.applyWaitersUserAgent(getAlarmMuteRuleRequest)), DefaultCloudWatchAsyncWaiter.alarmMuteRuleExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilCompositeAlarmExists(DescribeAlarmsRequest describeAlarmsRequest) {
        return this.compositeAlarmExistsWaiter.runAsync(() -> this.client.describeAlarms(this.applyWaitersUserAgent(describeAlarmsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilCompositeAlarmExists(DescribeAlarmsRequest describeAlarmsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.compositeAlarmExistsWaiter.runAsync(() -> this.client.describeAlarms(this.applyWaitersUserAgent(describeAlarmsRequest)), DefaultCloudWatchAsyncWaiter.compositeAlarmExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeAlarmsResponse>> alarmExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAlarmsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAlarmsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MetricAlarms").flatten().length().compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAlarmMuteRuleResponse>> alarmMuteRuleExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetAlarmMuteRuleResponse>> result = new ArrayList<WaiterAcceptor<? super GetAlarmMuteRuleResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAlarmsResponse>> compositeAlarmExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAlarmsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAlarmsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("CompositeAlarms").flatten().length().compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration alarmExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration alarmMuteRuleExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration compositeAlarmExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static CloudWatchAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends CloudWatchRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudWatchRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements CloudWatchAsyncWaiter.Builder {
        private CloudWatchAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public CloudWatchAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public CloudWatchAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public CloudWatchAsyncWaiter.Builder client(CloudWatchAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public CloudWatchAsyncWaiter build() {
            return new DefaultCloudWatchAsyncWaiter(this);
        }
    }
}

