/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetAlarmMuteRuleRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetAlarmMuteRuleResponse;
import software.amazon.awssdk.services.cloudwatch.waiters.DefaultCloudWatchAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface CloudWatchAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilAlarmExists(DescribeAlarmsRequest describeAlarmsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilAlarmExists(Consumer<DescribeAlarmsRequest.Builder> describeAlarmsRequest) {
        return this.waitUntilAlarmExists((DescribeAlarmsRequest)((Object)((DescribeAlarmsRequest.Builder)DescribeAlarmsRequest.builder().applyMutation(describeAlarmsRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilAlarmExists(DescribeAlarmsRequest describeAlarmsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilAlarmExists(Consumer<DescribeAlarmsRequest.Builder> describeAlarmsRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilAlarmExists((DescribeAlarmsRequest)((Object)((DescribeAlarmsRequest.Builder)DescribeAlarmsRequest.builder().applyMutation(describeAlarmsRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetAlarmMuteRuleResponse>> waitUntilAlarmMuteRuleExists(GetAlarmMuteRuleRequest getAlarmMuteRuleRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetAlarmMuteRuleResponse>> waitUntilAlarmMuteRuleExists(Consumer<GetAlarmMuteRuleRequest.Builder> getAlarmMuteRuleRequest) {
        return this.waitUntilAlarmMuteRuleExists((GetAlarmMuteRuleRequest)((Object)((GetAlarmMuteRuleRequest.Builder)GetAlarmMuteRuleRequest.builder().applyMutation(getAlarmMuteRuleRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetAlarmMuteRuleResponse>> waitUntilAlarmMuteRuleExists(GetAlarmMuteRuleRequest getAlarmMuteRuleRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetAlarmMuteRuleResponse>> waitUntilAlarmMuteRuleExists(Consumer<GetAlarmMuteRuleRequest.Builder> getAlarmMuteRuleRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilAlarmMuteRuleExists((GetAlarmMuteRuleRequest)((Object)((GetAlarmMuteRuleRequest.Builder)GetAlarmMuteRuleRequest.builder().applyMutation(getAlarmMuteRuleRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilCompositeAlarmExists(DescribeAlarmsRequest describeAlarmsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilCompositeAlarmExists(Consumer<DescribeAlarmsRequest.Builder> describeAlarmsRequest) {
        return this.waitUntilCompositeAlarmExists((DescribeAlarmsRequest)((Object)((DescribeAlarmsRequest.Builder)DescribeAlarmsRequest.builder().applyMutation(describeAlarmsRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilCompositeAlarmExists(DescribeAlarmsRequest describeAlarmsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeAlarmsResponse>> waitUntilCompositeAlarmExists(Consumer<DescribeAlarmsRequest.Builder> describeAlarmsRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilCompositeAlarmExists((DescribeAlarmsRequest)((Object)((DescribeAlarmsRequest.Builder)DescribeAlarmsRequest.builder().applyMutation(describeAlarmsRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultCloudWatchAsyncWaiter.builder();
    }

    public static CloudWatchAsyncWaiter create() {
        return DefaultCloudWatchAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(CloudWatchAsyncClient var1);

        public CloudWatchAsyncWaiter build();
    }
}

