/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.AlarmMuteRuleSummary;
import software.amazon.awssdk.services.cloudwatch.model.ListAlarmMuteRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListAlarmMuteRulesResponse;

public class ListAlarmMuteRulesPublisher
implements SdkPublisher<ListAlarmMuteRulesResponse> {
    private final CloudWatchAsyncClient client;
    private final ListAlarmMuteRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAlarmMuteRulesPublisher(CloudWatchAsyncClient client, ListAlarmMuteRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAlarmMuteRulesPublisher(CloudWatchAsyncClient client, ListAlarmMuteRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAlarmMuteRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAlarmMuteRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AlarmMuteRuleSummary> alarmMuteRuleSummaries() {
        return this.flatMapIterable(response -> response.alarmMuteRuleSummaries());
    }

    private class ListAlarmMuteRulesResponseFetcher
    implements AsyncPageFetcher<ListAlarmMuteRulesResponse> {
        private ListAlarmMuteRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListAlarmMuteRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAlarmMuteRulesResponse> nextPage(ListAlarmMuteRulesResponse previousPage) {
            if (previousPage == null) {
                return ListAlarmMuteRulesPublisher.this.client.listAlarmMuteRules(ListAlarmMuteRulesPublisher.this.firstRequest);
            }
            return ListAlarmMuteRulesPublisher.this.client.listAlarmMuteRules((ListAlarmMuteRulesRequest)((Object)ListAlarmMuteRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

