/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.AlarmMuteRuleSummary;
import software.amazon.awssdk.services.cloudwatch.model.ListAlarmMuteRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListAlarmMuteRulesResponse;

public class ListAlarmMuteRulesIterable
implements SdkIterable<ListAlarmMuteRulesResponse> {
    private final CloudWatchClient client;
    private final ListAlarmMuteRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAlarmMuteRulesIterable(CloudWatchClient client, ListAlarmMuteRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAlarmMuteRulesResponseFetcher();
    }

    public Iterator<ListAlarmMuteRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AlarmMuteRuleSummary> alarmMuteRuleSummaries() {
        Function<ListAlarmMuteRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.alarmMuteRuleSummaries() != null) {
                return response.alarmMuteRuleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAlarmMuteRulesResponseFetcher
    implements SyncPageFetcher<ListAlarmMuteRulesResponse> {
        private ListAlarmMuteRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListAlarmMuteRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAlarmMuteRulesResponse nextPage(ListAlarmMuteRulesResponse previousPage) {
            if (previousPage == null) {
                return ListAlarmMuteRulesIterable.this.client.listAlarmMuteRules(ListAlarmMuteRulesIterable.this.firstRequest);
            }
            return ListAlarmMuteRulesIterable.this.client.listAlarmMuteRules((ListAlarmMuteRulesRequest)((Object)ListAlarmMuteRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

