/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;

public class DescribeAlarmsPublisher
implements SdkPublisher<DescribeAlarmsResponse> {
    private final CloudWatchAsyncClient client;
    private final DescribeAlarmsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAlarmsPublisher(CloudWatchAsyncClient client, DescribeAlarmsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAlarmsPublisher(CloudWatchAsyncClient client, DescribeAlarmsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAlarmsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAlarmsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetricAlarm> metricAlarms() {
        return this.flatMapIterable(response -> response.metricAlarms());
    }

    public final SdkPublisher<CompositeAlarm> compositeAlarms() {
        return this.flatMapIterable(response -> response.compositeAlarms());
    }

    private class DescribeAlarmsResponseFetcher
    implements AsyncPageFetcher<DescribeAlarmsResponse> {
        private DescribeAlarmsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAlarmsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAlarmsResponse> nextPage(DescribeAlarmsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAlarmsPublisher.this.client.describeAlarms(DescribeAlarmsPublisher.this.firstRequest);
            }
            return DescribeAlarmsPublisher.this.client.describeAlarms((DescribeAlarmsRequest)((Object)DescribeAlarmsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

