/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.MuteTargets;
import software.amazon.awssdk.services.cloudwatch.model.Rule;
import software.amazon.awssdk.services.cloudwatch.model.Tag;
import software.amazon.awssdk.services.cloudwatch.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAlarmMuteRuleRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, PutAlarmMuteRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PutAlarmMuteRuleRequest.getter(PutAlarmMuteRuleRequest::name)).setter(PutAlarmMuteRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PutAlarmMuteRuleRequest.getter(PutAlarmMuteRuleRequest::description)).setter(PutAlarmMuteRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Rule> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rule").getter(PutAlarmMuteRuleRequest.getter(PutAlarmMuteRuleRequest::rule)).setter(PutAlarmMuteRuleRequest.setter(Builder::rule)).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()}).build();
    private static final SdkField<MuteTargets> MUTE_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MuteTargets").getter(PutAlarmMuteRuleRequest.getter(PutAlarmMuteRuleRequest::muteTargets)).setter(PutAlarmMuteRuleRequest.setter(Builder::muteTargets)).constructor(MuteTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MuteTargets").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PutAlarmMuteRuleRequest.getter(PutAlarmMuteRuleRequest::tags)).setter(PutAlarmMuteRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(PutAlarmMuteRuleRequest.getter(PutAlarmMuteRuleRequest::startDate)).setter(PutAlarmMuteRuleRequest.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> EXPIRE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpireDate").getter(PutAlarmMuteRuleRequest.getter(PutAlarmMuteRuleRequest::expireDate)).setter(PutAlarmMuteRuleRequest.setter(Builder::expireDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpireDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, RULE_FIELD, MUTE_TARGETS_FIELD, TAGS_FIELD, START_DATE_FIELD, EXPIRE_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAlarmMuteRuleRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final Rule rule;
    private final MuteTargets muteTargets;
    private final List<Tag> tags;
    private final Instant startDate;
    private final Instant expireDate;

    private PutAlarmMuteRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.rule = builder.rule;
        this.muteTargets = builder.muteTargets;
        this.tags = builder.tags;
        this.startDate = builder.startDate;
        this.expireDate = builder.expireDate;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Rule rule() {
        return this.rule;
    }

    public final MuteTargets muteTargets() {
        return this.muteTargets;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant expireDate() {
        return this.expireDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.muteTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expireDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAlarmMuteRuleRequest)) {
            return false;
        }
        PutAlarmMuteRuleRequest other = (PutAlarmMuteRuleRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.rule(), other.rule()) && Objects.equals(this.muteTargets(), other.muteTargets()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.expireDate(), other.expireDate());
    }

    public final String toString() {
        return ToString.builder((String)"PutAlarmMuteRuleRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Rule", (Object)this.rule()).add("MuteTargets", (Object)this.muteTargets()).add("Tags", this.hasTags() ? this.tags() : null).add("StartDate", (Object)this.startDate()).add("ExpireDate", (Object)this.expireDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "MuteTargets": {
                return Optional.ofNullable(clazz.cast(this.muteTargets()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "ExpireDate": {
                return Optional.ofNullable(clazz.cast(this.expireDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Rule", RULE_FIELD);
        map.put("MuteTargets", MUTE_TARGETS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("ExpireDate", EXPIRE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAlarmMuteRuleRequest, T> g) {
        return obj -> g.apply((PutAlarmMuteRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Rule rule;
        private MuteTargets muteTargets;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant startDate;
        private Instant expireDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAlarmMuteRuleRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.rule(model.rule);
            this.muteTargets(model.muteTargets);
            this.tags(model.tags);
            this.startDate(model.startDate);
            this.expireDate(model.expireDate);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Rule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(Rule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public final MuteTargets.Builder getMuteTargets() {
            return this.muteTargets != null ? this.muteTargets.toBuilder() : null;
        }

        public final void setMuteTargets(MuteTargets.BuilderImpl muteTargets) {
            this.muteTargets = muteTargets != null ? muteTargets.build() : null;
        }

        @Override
        public final Builder muteTargets(MuteTargets muteTargets) {
            this.muteTargets = muteTargets;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getExpireDate() {
            return this.expireDate;
        }

        public final void setExpireDate(Instant expireDate) {
            this.expireDate = expireDate;
        }

        @Override
        public final Builder expireDate(Instant expireDate) {
            this.expireDate = expireDate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAlarmMuteRuleRequest build() {
            return new PutAlarmMuteRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAlarmMuteRuleRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder rule(Rule var1);

        default public Builder rule(Consumer<Rule.Builder> rule) {
            return this.rule((Rule)((Rule.Builder)Rule.builder().applyMutation(rule)).build());
        }

        public Builder muteTargets(MuteTargets var1);

        default public Builder muteTargets(Consumer<MuteTargets.Builder> muteTargets) {
            return this.muteTargets((MuteTargets)((MuteTargets.Builder)MuteTargets.builder().applyMutation(muteTargets)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder startDate(Instant var1);

        public Builder expireDate(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

