/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.AlarmMuteRuleSummariesCopier;
import software.amazon.awssdk.services.cloudwatch.model.AlarmMuteRuleSummary;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAlarmMuteRulesResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, ListAlarmMuteRulesResponse> {
    private static final SdkField<List<AlarmMuteRuleSummary>> ALARM_MUTE_RULE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlarmMuteRuleSummaries").getter(ListAlarmMuteRulesResponse.getter(ListAlarmMuteRulesResponse::alarmMuteRuleSummaries)).setter(ListAlarmMuteRulesResponse.setter(Builder::alarmMuteRuleSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmMuteRuleSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmMuteRuleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAlarmMuteRulesResponse.getter(ListAlarmMuteRulesResponse::nextToken)).setter(ListAlarmMuteRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MUTE_RULE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAlarmMuteRulesResponse.memberNameToFieldInitializer();
    private final List<AlarmMuteRuleSummary> alarmMuteRuleSummaries;
    private final String nextToken;

    private ListAlarmMuteRulesResponse(BuilderImpl builder) {
        super(builder);
        this.alarmMuteRuleSummaries = builder.alarmMuteRuleSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAlarmMuteRuleSummaries() {
        return this.alarmMuteRuleSummaries != null && !(this.alarmMuteRuleSummaries instanceof SdkAutoConstructList);
    }

    public final List<AlarmMuteRuleSummary> alarmMuteRuleSummaries() {
        return this.alarmMuteRuleSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmMuteRuleSummaries() ? this.alarmMuteRuleSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlarmMuteRulesResponse)) {
            return false;
        }
        ListAlarmMuteRulesResponse other = (ListAlarmMuteRulesResponse)((Object)obj);
        return this.hasAlarmMuteRuleSummaries() == other.hasAlarmMuteRuleSummaries() && Objects.equals(this.alarmMuteRuleSummaries(), other.alarmMuteRuleSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAlarmMuteRulesResponse").add("AlarmMuteRuleSummaries", this.hasAlarmMuteRuleSummaries() ? this.alarmMuteRuleSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmMuteRuleSummaries": {
                return Optional.ofNullable(clazz.cast(this.alarmMuteRuleSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AlarmMuteRuleSummaries", ALARM_MUTE_RULE_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAlarmMuteRulesResponse, T> g) {
        return obj -> g.apply((ListAlarmMuteRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<AlarmMuteRuleSummary> alarmMuteRuleSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlarmMuteRulesResponse model) {
            super(model);
            this.alarmMuteRuleSummaries(model.alarmMuteRuleSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AlarmMuteRuleSummary.Builder> getAlarmMuteRuleSummaries() {
            List<AlarmMuteRuleSummary.Builder> result = AlarmMuteRuleSummariesCopier.copyToBuilder(this.alarmMuteRuleSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarmMuteRuleSummaries(Collection<AlarmMuteRuleSummary.BuilderImpl> alarmMuteRuleSummaries) {
            this.alarmMuteRuleSummaries = AlarmMuteRuleSummariesCopier.copyFromBuilder(alarmMuteRuleSummaries);
        }

        @Override
        public final Builder alarmMuteRuleSummaries(Collection<AlarmMuteRuleSummary> alarmMuteRuleSummaries) {
            this.alarmMuteRuleSummaries = AlarmMuteRuleSummariesCopier.copy(alarmMuteRuleSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmMuteRuleSummaries(AlarmMuteRuleSummary ... alarmMuteRuleSummaries) {
            this.alarmMuteRuleSummaries(Arrays.asList(alarmMuteRuleSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmMuteRuleSummaries(Consumer<AlarmMuteRuleSummary.Builder> ... alarmMuteRuleSummaries) {
            this.alarmMuteRuleSummaries(Stream.of(alarmMuteRuleSummaries).map(c -> (AlarmMuteRuleSummary)((AlarmMuteRuleSummary.Builder)AlarmMuteRuleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAlarmMuteRulesResponse build() {
            return new ListAlarmMuteRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAlarmMuteRulesResponse> {
        public Builder alarmMuteRuleSummaries(Collection<AlarmMuteRuleSummary> var1);

        public Builder alarmMuteRuleSummaries(AlarmMuteRuleSummary ... var1);

        public Builder alarmMuteRuleSummaries(Consumer<AlarmMuteRuleSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

