/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatch.model.AlarmMuteRuleStatus;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.MuteTargets;
import software.amazon.awssdk.services.cloudwatch.model.Rule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAlarmMuteRuleResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, GetAlarmMuteRuleResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetAlarmMuteRuleResponse.getter(GetAlarmMuteRuleResponse::name)).setter(GetAlarmMuteRuleResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ALARM_MUTE_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmMuteRuleArn").getter(GetAlarmMuteRuleResponse.getter(GetAlarmMuteRuleResponse::alarmMuteRuleArn)).setter(GetAlarmMuteRuleResponse.setter(Builder::alarmMuteRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmMuteRuleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetAlarmMuteRuleResponse.getter(GetAlarmMuteRuleResponse::description)).setter(GetAlarmMuteRuleResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Rule> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rule").getter(GetAlarmMuteRuleResponse.getter(GetAlarmMuteRuleResponse::rule)).setter(GetAlarmMuteRuleResponse.setter(Builder::rule)).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()}).build();
    private static final SdkField<MuteTargets> MUTE_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MuteTargets").getter(GetAlarmMuteRuleResponse.getter(GetAlarmMuteRuleResponse::muteTargets)).setter(GetAlarmMuteRuleResponse.setter(Builder::muteTargets)).constructor(MuteTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MuteTargets").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(GetAlarmMuteRuleResponse.getter(GetAlarmMuteRuleResponse::startDate)).setter(GetAlarmMuteRuleResponse.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> EXPIRE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpireDate").getter(GetAlarmMuteRuleResponse.getter(GetAlarmMuteRuleResponse::expireDate)).setter(GetAlarmMuteRuleResponse.setter(Builder::expireDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpireDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetAlarmMuteRuleResponse.getter(GetAlarmMuteRuleResponse::statusAsString)).setter(GetAlarmMuteRuleResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(GetAlarmMuteRuleResponse.getter(GetAlarmMuteRuleResponse::lastUpdatedTimestamp)).setter(GetAlarmMuteRuleResponse.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<String> MUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MuteType").getter(GetAlarmMuteRuleResponse.getter(GetAlarmMuteRuleResponse::muteType)).setter(GetAlarmMuteRuleResponse.setter(Builder::muteType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MuteType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ALARM_MUTE_RULE_ARN_FIELD, DESCRIPTION_FIELD, RULE_FIELD, MUTE_TARGETS_FIELD, START_DATE_FIELD, EXPIRE_DATE_FIELD, STATUS_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, MUTE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAlarmMuteRuleResponse.memberNameToFieldInitializer();
    private final String name;
    private final String alarmMuteRuleArn;
    private final String description;
    private final Rule rule;
    private final MuteTargets muteTargets;
    private final Instant startDate;
    private final Instant expireDate;
    private final String status;
    private final Instant lastUpdatedTimestamp;
    private final String muteType;

    private GetAlarmMuteRuleResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.alarmMuteRuleArn = builder.alarmMuteRuleArn;
        this.description = builder.description;
        this.rule = builder.rule;
        this.muteTargets = builder.muteTargets;
        this.startDate = builder.startDate;
        this.expireDate = builder.expireDate;
        this.status = builder.status;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.muteType = builder.muteType;
    }

    public final String name() {
        return this.name;
    }

    public final String alarmMuteRuleArn() {
        return this.alarmMuteRuleArn;
    }

    public final String description() {
        return this.description;
    }

    public final Rule rule() {
        return this.rule;
    }

    public final MuteTargets muteTargets() {
        return this.muteTargets;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant expireDate() {
        return this.expireDate;
    }

    public final AlarmMuteRuleStatus status() {
        return AlarmMuteRuleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final String muteType() {
        return this.muteType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmMuteRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.muteTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expireDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.muteType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAlarmMuteRuleResponse)) {
            return false;
        }
        GetAlarmMuteRuleResponse other = (GetAlarmMuteRuleResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.alarmMuteRuleArn(), other.alarmMuteRuleArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.rule(), other.rule()) && Objects.equals(this.muteTargets(), other.muteTargets()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.expireDate(), other.expireDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.muteType(), other.muteType());
    }

    public final String toString() {
        return ToString.builder((String)"GetAlarmMuteRuleResponse").add("Name", (Object)this.name()).add("AlarmMuteRuleArn", (Object)this.alarmMuteRuleArn()).add("Description", (Object)this.description()).add("Rule", (Object)this.rule()).add("MuteTargets", (Object)this.muteTargets()).add("StartDate", (Object)this.startDate()).add("ExpireDate", (Object)this.expireDate()).add("Status", (Object)this.statusAsString()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("MuteType", (Object)this.muteType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AlarmMuteRuleArn": {
                return Optional.ofNullable(clazz.cast(this.alarmMuteRuleArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "MuteTargets": {
                return Optional.ofNullable(clazz.cast(this.muteTargets()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "ExpireDate": {
                return Optional.ofNullable(clazz.cast(this.expireDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "MuteType": {
                return Optional.ofNullable(clazz.cast(this.muteType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("AlarmMuteRuleArn", ALARM_MUTE_RULE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Rule", RULE_FIELD);
        map.put("MuteTargets", MUTE_TARGETS_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("ExpireDate", EXPIRE_DATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("MuteType", MUTE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAlarmMuteRuleResponse, T> g) {
        return obj -> g.apply((GetAlarmMuteRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private String name;
        private String alarmMuteRuleArn;
        private String description;
        private Rule rule;
        private MuteTargets muteTargets;
        private Instant startDate;
        private Instant expireDate;
        private String status;
        private Instant lastUpdatedTimestamp;
        private String muteType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAlarmMuteRuleResponse model) {
            super(model);
            this.name(model.name);
            this.alarmMuteRuleArn(model.alarmMuteRuleArn);
            this.description(model.description);
            this.rule(model.rule);
            this.muteTargets(model.muteTargets);
            this.startDate(model.startDate);
            this.expireDate(model.expireDate);
            this.status(model.status);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.muteType(model.muteType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAlarmMuteRuleArn() {
            return this.alarmMuteRuleArn;
        }

        public final void setAlarmMuteRuleArn(String alarmMuteRuleArn) {
            this.alarmMuteRuleArn = alarmMuteRuleArn;
        }

        @Override
        public final Builder alarmMuteRuleArn(String alarmMuteRuleArn) {
            this.alarmMuteRuleArn = alarmMuteRuleArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Rule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(Rule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public final MuteTargets.Builder getMuteTargets() {
            return this.muteTargets != null ? this.muteTargets.toBuilder() : null;
        }

        public final void setMuteTargets(MuteTargets.BuilderImpl muteTargets) {
            this.muteTargets = muteTargets != null ? muteTargets.build() : null;
        }

        @Override
        public final Builder muteTargets(MuteTargets muteTargets) {
            this.muteTargets = muteTargets;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getExpireDate() {
            return this.expireDate;
        }

        public final void setExpireDate(Instant expireDate) {
            this.expireDate = expireDate;
        }

        @Override
        public final Builder expireDate(Instant expireDate) {
            this.expireDate = expireDate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AlarmMuteRuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getMuteType() {
            return this.muteType;
        }

        public final void setMuteType(String muteType) {
            this.muteType = muteType;
        }

        @Override
        public final Builder muteType(String muteType) {
            this.muteType = muteType;
            return this;
        }

        @Override
        public GetAlarmMuteRuleResponse build() {
            return new GetAlarmMuteRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAlarmMuteRuleResponse> {
        public Builder name(String var1);

        public Builder alarmMuteRuleArn(String var1);

        public Builder description(String var1);

        public Builder rule(Rule var1);

        default public Builder rule(Consumer<Rule.Builder> rule) {
            return this.rule((Rule)((Rule.Builder)Rule.builder().applyMutation(rule)).build());
        }

        public Builder muteTargets(MuteTargets var1);

        default public Builder muteTargets(Consumer<MuteTargets.Builder> muteTargets) {
            return this.muteTargets((MuteTargets)((MuteTargets.Builder)MuteTargets.builder().applyMutation(muteTargets)).build());
        }

        public Builder startDate(Instant var1);

        public Builder expireDate(Instant var1);

        public Builder status(String var1);

        public Builder status(AlarmMuteRuleStatus var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder muteType(String var1);
    }
}

