/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatch.model.AlarmMuteRuleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmMuteRuleSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmMuteRuleSummary> {
    private static final SdkField<String> ALARM_MUTE_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmMuteRuleArn").getter(AlarmMuteRuleSummary.getter(AlarmMuteRuleSummary::alarmMuteRuleArn)).setter(AlarmMuteRuleSummary.setter(Builder::alarmMuteRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmMuteRuleArn").build()}).build();
    private static final SdkField<Instant> EXPIRE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpireDate").getter(AlarmMuteRuleSummary.getter(AlarmMuteRuleSummary::expireDate)).setter(AlarmMuteRuleSummary.setter(Builder::expireDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpireDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AlarmMuteRuleSummary.getter(AlarmMuteRuleSummary::statusAsString)).setter(AlarmMuteRuleSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MuteType").getter(AlarmMuteRuleSummary.getter(AlarmMuteRuleSummary::muteType)).setter(AlarmMuteRuleSummary.setter(Builder::muteType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MuteType").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(AlarmMuteRuleSummary.getter(AlarmMuteRuleSummary::lastUpdatedTimestamp)).setter(AlarmMuteRuleSummary.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MUTE_RULE_ARN_FIELD, EXPIRE_DATE_FIELD, STATUS_FIELD, MUTE_TYPE_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlarmMuteRuleSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alarmMuteRuleArn;
    private final Instant expireDate;
    private final String status;
    private final String muteType;
    private final Instant lastUpdatedTimestamp;

    private AlarmMuteRuleSummary(BuilderImpl builder) {
        this.alarmMuteRuleArn = builder.alarmMuteRuleArn;
        this.expireDate = builder.expireDate;
        this.status = builder.status;
        this.muteType = builder.muteType;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    public final String alarmMuteRuleArn() {
        return this.alarmMuteRuleArn;
    }

    public final Instant expireDate() {
        return this.expireDate;
    }

    public final AlarmMuteRuleStatus status() {
        return AlarmMuteRuleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String muteType() {
        return this.muteType;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmMuteRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.expireDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.muteType());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmMuteRuleSummary)) {
            return false;
        }
        AlarmMuteRuleSummary other = (AlarmMuteRuleSummary)obj;
        return Objects.equals(this.alarmMuteRuleArn(), other.alarmMuteRuleArn()) && Objects.equals(this.expireDate(), other.expireDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.muteType(), other.muteType()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmMuteRuleSummary").add("AlarmMuteRuleArn", (Object)this.alarmMuteRuleArn()).add("ExpireDate", (Object)this.expireDate()).add("Status", (Object)this.statusAsString()).add("MuteType", (Object)this.muteType()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmMuteRuleArn": {
                return Optional.ofNullable(clazz.cast(this.alarmMuteRuleArn()));
            }
            case "ExpireDate": {
                return Optional.ofNullable(clazz.cast(this.expireDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "MuteType": {
                return Optional.ofNullable(clazz.cast(this.muteType()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AlarmMuteRuleArn", ALARM_MUTE_RULE_ARN_FIELD);
        map.put("ExpireDate", EXPIRE_DATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("MuteType", MUTE_TYPE_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlarmMuteRuleSummary, T> g) {
        return obj -> g.apply((AlarmMuteRuleSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alarmMuteRuleArn;
        private Instant expireDate;
        private String status;
        private String muteType;
        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmMuteRuleSummary model) {
            this.alarmMuteRuleArn(model.alarmMuteRuleArn);
            this.expireDate(model.expireDate);
            this.status(model.status);
            this.muteType(model.muteType);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getAlarmMuteRuleArn() {
            return this.alarmMuteRuleArn;
        }

        public final void setAlarmMuteRuleArn(String alarmMuteRuleArn) {
            this.alarmMuteRuleArn = alarmMuteRuleArn;
        }

        @Override
        public final Builder alarmMuteRuleArn(String alarmMuteRuleArn) {
            this.alarmMuteRuleArn = alarmMuteRuleArn;
            return this;
        }

        public final Instant getExpireDate() {
            return this.expireDate;
        }

        public final void setExpireDate(Instant expireDate) {
            this.expireDate = expireDate;
        }

        @Override
        public final Builder expireDate(Instant expireDate) {
            this.expireDate = expireDate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AlarmMuteRuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMuteType() {
            return this.muteType;
        }

        public final void setMuteType(String muteType) {
            this.muteType = muteType;
        }

        @Override
        public final Builder muteType(String muteType) {
            this.muteType = muteType;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public AlarmMuteRuleSummary build() {
            return new AlarmMuteRuleSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmMuteRuleSummary> {
        public Builder alarmMuteRuleArn(String var1);

        public Builder expireDate(Instant var1);

        public Builder status(String var1);

        public Builder status(AlarmMuteRuleStatus var1);

        public Builder muteType(String var1);

        public Builder lastUpdatedTimestamp(Instant var1);
    }
}

