/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.DashboardEntry;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse;

public class ListDashboardsPublisher
implements SdkPublisher<ListDashboardsResponse> {
    private final CloudWatchAsyncClient client;
    private final ListDashboardsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDashboardsPublisher(CloudWatchAsyncClient client, ListDashboardsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDashboardsPublisher(CloudWatchAsyncClient client, ListDashboardsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDashboardsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDashboardsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DashboardEntry> dashboardEntries() {
        return this.flatMapIterable(response -> response.dashboardEntries());
    }

    private class ListDashboardsResponseFetcher
    implements AsyncPageFetcher<ListDashboardsResponse> {
        private ListDashboardsResponseFetcher() {
        }

        public boolean hasNextPage(ListDashboardsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDashboardsResponse> nextPage(ListDashboardsResponse previousPage) {
            if (previousPage == null) {
                return ListDashboardsPublisher.this.client.listDashboards(ListDashboardsPublisher.this.firstRequest);
            }
            return ListDashboardsPublisher.this.client.listDashboards((ListDashboardsRequest)((Object)ListDashboardsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

