/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.AnomalyDetector;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse;

public class DescribeAnomalyDetectorsPublisher
implements SdkPublisher<DescribeAnomalyDetectorsResponse> {
    private final CloudWatchAsyncClient client;
    private final DescribeAnomalyDetectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAnomalyDetectorsPublisher(CloudWatchAsyncClient client, DescribeAnomalyDetectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAnomalyDetectorsPublisher(CloudWatchAsyncClient client, DescribeAnomalyDetectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAnomalyDetectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAnomalyDetectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnomalyDetector> anomalyDetectors() {
        return this.flatMapIterable(response -> response.anomalyDetectors());
    }

    private class DescribeAnomalyDetectorsResponseFetcher
    implements AsyncPageFetcher<DescribeAnomalyDetectorsResponse> {
        private DescribeAnomalyDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAnomalyDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAnomalyDetectorsResponse> nextPage(DescribeAnomalyDetectorsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAnomalyDetectorsPublisher.this.client.describeAnomalyDetectors(DescribeAnomalyDetectorsPublisher.this.firstRequest);
            }
            return DescribeAnomalyDetectorsPublisher.this.client.describeAnomalyDetectors((DescribeAnomalyDetectorsRequest)((Object)DescribeAnomalyDetectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

