/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon CloudWatch monitors your Amazon Web Services (Amazon Web Services) resources and the applications you run on
 * Amazon Web Services in real time. You can use CloudWatch to collect and track metrics, which are the variables you
 * want to measure for your resources and applications.
 * </p>
 * <p>
 * CloudWatch alarms send notifications or automatically change the resources you are monitoring based on rules that you
 * define. For example, you can monitor the CPU usage and disk reads and writes of your Amazon EC2 instances. Then, use
 * this data to determine whether you should launch additional instances to handle increased load. You can also use this
 * data to stop under-used instances to save money.
 * </p>
 * <p>
 * In addition to monitoring the built-in metrics that come with Amazon Web Services, you can monitor your own custom
 * metrics. With CloudWatch, you gain system-wide visibility into resource utilization, application performance, and
 * operational health.
 * </p>
 *
 * <h2>Code Examples</h2>
 * <p>
 * For code examples demonstrating how to use this service with the AWS SDK for Java v2, see:
 * </p>
 * <h3>Getting Started</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_Hello_section.html"
 * target="_top">Hello CloudWatch</a></li>
 * </ul>
 * <h3>Basics</h3>
 * <ul>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_GetStartedMetricsDashboardsAlarms_section.html"
 * target="_top">Learn core operations for CloudWatch using an AWS SDK</a></li>
 * </ul>
 * <h3>API Actions</h3>
 * <ul>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_DeleteAlarms_section.html"
 * target="_top">Use DeleteAlarms</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_DeleteAnomalyDetector_section.html"
 * target="_top">Use DeleteAnomalyDetector</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_DeleteDashboards_section.html"
 * target="_top">Use DeleteDashboards</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_DescribeAlarmHistory_section.html"
 * target="_top">Use DescribeAlarmHistory</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_DescribeAlarms_section.html"
 * target="_top">Use DescribeAlarms</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_DescribeAlarmsForMetric_section.html"
 * target="_top">Use DescribeAlarmsForMetric</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_DescribeAnomalyDetectors_section.html"
 * target="_top">Use DescribeAnomalyDetectors</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_DisableAlarmActions_section.html"
 * target="_top">Use DisableAlarmActions</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_EnableAlarmActions_section.html"
 * target="_top">Use EnableAlarmActions</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_GetMetricData_section.html"
 * target="_top">Use GetMetricData</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_GetMetricStatistics_section.html"
 * target="_top">Use GetMetricStatistics</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_GetMetricWidgetImage_section.html"
 * target="_top">Use GetMetricWidgetImage</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_ListDashboards_section.html"
 * target="_top">Use ListDashboards</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_ListMetrics_section.html"
 * target="_top">Use ListMetrics</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_PutAnomalyDetector_section.html"
 * target="_top">Use PutAnomalyDetector</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_PutDashboard_section.html"
 * target="_top">Use PutDashboard</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_PutMetricAlarm_section.html"
 * target="_top">Use PutMetricAlarm</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cloudwatch_PutMetricData_section.html"
 * target="_top">Use PutMetricData</a></li>
 * </ul>
 * <h3>Scenarios</h3>
 * <ul>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/cloudwatch_example_cross_MonitorDynamoDB_section.html"
 * target="_top">Monitor performance of Amazon DynamoDB using an AWS SDK</a></li>
 * </ul>
 */
package software.amazon.awssdk.services.cloudwatch;