/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.Entity;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityMetricData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityMetricData> {
    private static final SdkField<Entity> ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Entity").getter(EntityMetricData.getter(EntityMetricData::entity)).setter(EntityMetricData.setter(Builder::entity)).constructor(Entity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entity").build()}).build();
    private static final SdkField<List<MetricDatum>> METRIC_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricData").getter(EntityMetricData.getter(EntityMetricData::metricData)).setter(EntityMetricData.setter(Builder::metricData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDatum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_FIELD, METRIC_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EntityMetricData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Entity entity;
    private final List<MetricDatum> metricData;

    private EntityMetricData(BuilderImpl builder) {
        this.entity = builder.entity;
        this.metricData = builder.metricData;
    }

    public final Entity entity() {
        return this.entity;
    }

    public final boolean hasMetricData() {
        return this.metricData != null && !(this.metricData instanceof SdkAutoConstructList);
    }

    public final List<MetricDatum> metricData() {
        return this.metricData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricData() ? this.metricData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityMetricData)) {
            return false;
        }
        EntityMetricData other = (EntityMetricData)obj;
        return Objects.equals(this.entity(), other.entity()) && this.hasMetricData() == other.hasMetricData() && Objects.equals(this.metricData(), other.metricData());
    }

    public final String toString() {
        return ToString.builder((String)"EntityMetricData").add("Entity", (Object)this.entity()).add("MetricData", this.hasMetricData() ? this.metricData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entity": {
                return Optional.ofNullable(clazz.cast(this.entity()));
            }
            case "MetricData": {
                return Optional.ofNullable(clazz.cast(this.metricData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Entity", ENTITY_FIELD);
        map.put("MetricData", METRIC_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EntityMetricData, T> g) {
        return obj -> g.apply((EntityMetricData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Entity entity;
        private List<MetricDatum> metricData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityMetricData model) {
            this.entity(model.entity);
            this.metricData(model.metricData);
        }

        public final Entity.Builder getEntity() {
            return this.entity != null ? this.entity.toBuilder() : null;
        }

        public final void setEntity(Entity.BuilderImpl entity) {
            this.entity = entity != null ? entity.build() : null;
        }

        @Override
        public final Builder entity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public final List<MetricDatum.Builder> getMetricData() {
            List<MetricDatum.Builder> result = MetricDataCopier.copyToBuilder(this.metricData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricData(Collection<MetricDatum.BuilderImpl> metricData) {
            this.metricData = MetricDataCopier.copyFromBuilder(metricData);
        }

        @Override
        public final Builder metricData(Collection<MetricDatum> metricData) {
            this.metricData = MetricDataCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatum ... metricData) {
            this.metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(Consumer<MetricDatum.Builder> ... metricData) {
            this.metricData(Stream.of(metricData).map(c -> (MetricDatum)((MetricDatum.Builder)MetricDatum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EntityMetricData build() {
            return new EntityMetricData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityMetricData> {
        public Builder entity(Entity var1);

        default public Builder entity(Consumer<Entity.Builder> entity) {
            return this.entity((Entity)((Entity.Builder)Entity.builder().applyMutation(entity)).build());
        }

        public Builder metricData(Collection<MetricDatum> var1);

        public Builder metricData(MetricDatum ... var1);

        public Builder metricData(Consumer<MetricDatum.Builder> ... var1);
    }
}

