/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilterMetricNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricStreamFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricStreamFilter> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(MetricStreamFilter.getter(MetricStreamFilter::namespace)).setter(MetricStreamFilter.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<List<String>> METRIC_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricNames").getter(MetricStreamFilter.getter(MetricStreamFilter::metricNames)).setter(MetricStreamFilter.setter(Builder::metricNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, METRIC_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricStreamFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final List<String> metricNames;

    private MetricStreamFilter(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.metricNames = builder.metricNames;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final boolean hasMetricNames() {
        return this.metricNames != null && !(this.metricNames instanceof SdkAutoConstructList);
    }

    public final List<String> metricNames() {
        return this.metricNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricNames() ? this.metricNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricStreamFilter)) {
            return false;
        }
        MetricStreamFilter other = (MetricStreamFilter)obj;
        return Objects.equals(this.namespace(), other.namespace()) && this.hasMetricNames() == other.hasMetricNames() && Objects.equals(this.metricNames(), other.metricNames());
    }

    public final String toString() {
        return ToString.builder((String)"MetricStreamFilter").add("Namespace", (Object)this.namespace()).add("MetricNames", this.hasMetricNames() ? this.metricNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "MetricNames": {
                return Optional.ofNullable(clazz.cast(this.metricNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("MetricNames", METRIC_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricStreamFilter, T> g) {
        return obj -> g.apply((MetricStreamFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private List<String> metricNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricStreamFilter model) {
            this.namespace(model.namespace);
            this.metricNames(model.metricNames);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final Collection<String> getMetricNames() {
            if (this.metricNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricNames;
        }

        public final void setMetricNames(Collection<String> metricNames) {
            this.metricNames = MetricStreamFilterMetricNamesCopier.copy(metricNames);
        }

        @Override
        public final Builder metricNames(Collection<String> metricNames) {
            this.metricNames = MetricStreamFilterMetricNamesCopier.copy(metricNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricNames(String ... metricNames) {
            this.metricNames(Arrays.asList(metricNames));
            return this;
        }

        public MetricStreamFilter build() {
            return new MetricStreamFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricStreamFilter> {
        public Builder namespace(String var1);

        public Builder metricNames(Collection<String> var1);

        public Builder metricNames(String ... var1);
    }
}

