/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HistoryItemType {
    CONFIGURATION_UPDATE("ConfigurationUpdate"),
    STATE_UPDATE("StateUpdate"),
    ACTION("Action"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HistoryItemType> VALUE_MAP;
    private final String value;

    private HistoryItemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HistoryItemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HistoryItemType> knownValues() {
        EnumSet<HistoryItemType> knownValues = EnumSet.allOf(HistoryItemType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HistoryItemType.class, HistoryItemType::toString);
    }
}

