/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnomalyDetectorStateValue {
    PENDING_TRAINING("PENDING_TRAINING"),
    TRAINED_INSUFFICIENT_DATA("TRAINED_INSUFFICIENT_DATA"),
    TRAINED("TRAINED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnomalyDetectorStateValue> VALUE_MAP;
    private final String value;

    private AnomalyDetectorStateValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnomalyDetectorStateValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnomalyDetectorStateValue> knownValues() {
        EnumSet<AnomalyDetectorStateValue> knownValues = EnumSet.allOf(AnomalyDetectorStateValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnomalyDetectorStateValue.class, AnomalyDetectorStateValue::toString);
    }
}

