/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamFiltersCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetricStreamResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, GetMetricStreamResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::arn)).setter(GetMetricStreamResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::name)).setter(GetMetricStreamResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<MetricStreamFilter>> INCLUDE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeFilters").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::includeFilters)).setter(GetMetricStreamResponse.setter(Builder::includeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricStreamFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricStreamFilter>> EXCLUDE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeFilters").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::excludeFilters)).setter(GetMetricStreamResponse.setter(Builder::excludeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricStreamFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FIREHOSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirehoseArn").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::firehoseArn)).setter(GetMetricStreamResponse.setter(Builder::firehoseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::roleArn)).setter(GetMetricStreamResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::state)).setter(GetMetricStreamResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::creationDate)).setter(GetMetricStreamResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateDate").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::lastUpdateDate)).setter(GetMetricStreamResponse.setter(Builder::lastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDate").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::outputFormatAsString)).setter(GetMetricStreamResponse.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()}).build();
    private static final SdkField<List<MetricStreamStatisticsConfiguration>> STATISTICS_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatisticsConfigurations").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::statisticsConfigurations)).setter(GetMetricStreamResponse.setter(Builder::statisticsConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticsConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricStreamStatisticsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_LINKED_ACCOUNTS_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeLinkedAccountsMetrics").getter(GetMetricStreamResponse.getter(GetMetricStreamResponse::includeLinkedAccountsMetrics)).setter(GetMetricStreamResponse.setter(Builder::includeLinkedAccountsMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeLinkedAccountsMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, INCLUDE_FILTERS_FIELD, EXCLUDE_FILTERS_FIELD, FIREHOSE_ARN_FIELD, ROLE_ARN_FIELD, STATE_FIELD, CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD, OUTPUT_FORMAT_FIELD, STATISTICS_CONFIGURATIONS_FIELD, INCLUDE_LINKED_ACCOUNTS_METRICS_FIELD));
    private final String arn;
    private final String name;
    private final List<MetricStreamFilter> includeFilters;
    private final List<MetricStreamFilter> excludeFilters;
    private final String firehoseArn;
    private final String roleArn;
    private final String state;
    private final Instant creationDate;
    private final Instant lastUpdateDate;
    private final String outputFormat;
    private final List<MetricStreamStatisticsConfiguration> statisticsConfigurations;
    private final Boolean includeLinkedAccountsMetrics;

    private GetMetricStreamResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.includeFilters = builder.includeFilters;
        this.excludeFilters = builder.excludeFilters;
        this.firehoseArn = builder.firehoseArn;
        this.roleArn = builder.roleArn;
        this.state = builder.state;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
        this.outputFormat = builder.outputFormat;
        this.statisticsConfigurations = builder.statisticsConfigurations;
        this.includeLinkedAccountsMetrics = builder.includeLinkedAccountsMetrics;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasIncludeFilters() {
        return this.includeFilters != null && !(this.includeFilters instanceof SdkAutoConstructList);
    }

    public final List<MetricStreamFilter> includeFilters() {
        return this.includeFilters;
    }

    public final boolean hasExcludeFilters() {
        return this.excludeFilters != null && !(this.excludeFilters instanceof SdkAutoConstructList);
    }

    public final List<MetricStreamFilter> excludeFilters() {
        return this.excludeFilters;
    }

    public final String firehoseArn() {
        return this.firehoseArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String state() {
        return this.state;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastUpdateDate() {
        return this.lastUpdateDate;
    }

    public final MetricStreamOutputFormat outputFormat() {
        return MetricStreamOutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public final boolean hasStatisticsConfigurations() {
        return this.statisticsConfigurations != null && !(this.statisticsConfigurations instanceof SdkAutoConstructList);
    }

    public final List<MetricStreamStatisticsConfiguration> statisticsConfigurations() {
        return this.statisticsConfigurations;
    }

    public final Boolean includeLinkedAccountsMetrics() {
        return this.includeLinkedAccountsMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeFilters() ? this.includeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeFilters() ? this.excludeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.firehoseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatisticsConfigurations() ? this.statisticsConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeLinkedAccountsMetrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStreamResponse)) {
            return false;
        }
        GetMetricStreamResponse other = (GetMetricStreamResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && this.hasIncludeFilters() == other.hasIncludeFilters() && Objects.equals(this.includeFilters(), other.includeFilters()) && this.hasExcludeFilters() == other.hasExcludeFilters() && Objects.equals(this.excludeFilters(), other.excludeFilters()) && Objects.equals(this.firehoseArn(), other.firehoseArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastUpdateDate(), other.lastUpdateDate()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && this.hasStatisticsConfigurations() == other.hasStatisticsConfigurations() && Objects.equals(this.statisticsConfigurations(), other.statisticsConfigurations()) && Objects.equals(this.includeLinkedAccountsMetrics(), other.includeLinkedAccountsMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"GetMetricStreamResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("IncludeFilters", this.hasIncludeFilters() ? this.includeFilters() : null).add("ExcludeFilters", this.hasExcludeFilters() ? this.excludeFilters() : null).add("FirehoseArn", (Object)this.firehoseArn()).add("RoleArn", (Object)this.roleArn()).add("State", (Object)this.state()).add("CreationDate", (Object)this.creationDate()).add("LastUpdateDate", (Object)this.lastUpdateDate()).add("OutputFormat", (Object)this.outputFormatAsString()).add("StatisticsConfigurations", this.hasStatisticsConfigurations() ? this.statisticsConfigurations() : null).add("IncludeLinkedAccountsMetrics", (Object)this.includeLinkedAccountsMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IncludeFilters": {
                return Optional.ofNullable(clazz.cast(this.includeFilters()));
            }
            case "ExcludeFilters": {
                return Optional.ofNullable(clazz.cast(this.excludeFilters()));
            }
            case "FirehoseArn": {
                return Optional.ofNullable(clazz.cast(this.firehoseArn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "LastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDate()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "StatisticsConfigurations": {
                return Optional.ofNullable(clazz.cast(this.statisticsConfigurations()));
            }
            case "IncludeLinkedAccountsMetrics": {
                return Optional.ofNullable(clazz.cast(this.includeLinkedAccountsMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricStreamResponse, T> g) {
        return obj -> g.apply((GetMetricStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private List<MetricStreamFilter> includeFilters = DefaultSdkAutoConstructList.getInstance();
        private List<MetricStreamFilter> excludeFilters = DefaultSdkAutoConstructList.getInstance();
        private String firehoseArn;
        private String roleArn;
        private String state;
        private Instant creationDate;
        private Instant lastUpdateDate;
        private String outputFormat;
        private List<MetricStreamStatisticsConfiguration> statisticsConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeLinkedAccountsMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStreamResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.includeFilters(model.includeFilters);
            this.excludeFilters(model.excludeFilters);
            this.firehoseArn(model.firehoseArn);
            this.roleArn(model.roleArn);
            this.state(model.state);
            this.creationDate(model.creationDate);
            this.lastUpdateDate(model.lastUpdateDate);
            this.outputFormat(model.outputFormat);
            this.statisticsConfigurations(model.statisticsConfigurations);
            this.includeLinkedAccountsMetrics(model.includeLinkedAccountsMetrics);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<MetricStreamFilter.Builder> getIncludeFilters() {
            List<MetricStreamFilter.Builder> result = MetricStreamFiltersCopier.copyToBuilder(this.includeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludeFilters(Collection<MetricStreamFilter.BuilderImpl> includeFilters) {
            this.includeFilters = MetricStreamFiltersCopier.copyFromBuilder(includeFilters);
        }

        @Override
        public final Builder includeFilters(Collection<MetricStreamFilter> includeFilters) {
            this.includeFilters = MetricStreamFiltersCopier.copy(includeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFilters(MetricStreamFilter ... includeFilters) {
            this.includeFilters(Arrays.asList(includeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFilters(Consumer<MetricStreamFilter.Builder> ... includeFilters) {
            this.includeFilters(Stream.of(includeFilters).map(c -> (MetricStreamFilter)((MetricStreamFilter.Builder)MetricStreamFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MetricStreamFilter.Builder> getExcludeFilters() {
            List<MetricStreamFilter.Builder> result = MetricStreamFiltersCopier.copyToBuilder(this.excludeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeFilters(Collection<MetricStreamFilter.BuilderImpl> excludeFilters) {
            this.excludeFilters = MetricStreamFiltersCopier.copyFromBuilder(excludeFilters);
        }

        @Override
        public final Builder excludeFilters(Collection<MetricStreamFilter> excludeFilters) {
            this.excludeFilters = MetricStreamFiltersCopier.copy(excludeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeFilters(MetricStreamFilter ... excludeFilters) {
            this.excludeFilters(Arrays.asList(excludeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeFilters(Consumer<MetricStreamFilter.Builder> ... excludeFilters) {
            this.excludeFilters(Stream.of(excludeFilters).map(c -> (MetricStreamFilter)((MetricStreamFilter.Builder)MetricStreamFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFirehoseArn() {
            return this.firehoseArn;
        }

        public final void setFirehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
        }

        @Override
        public final Builder firehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(MetricStreamOutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final List<MetricStreamStatisticsConfiguration.Builder> getStatisticsConfigurations() {
            List<MetricStreamStatisticsConfiguration.Builder> result = MetricStreamStatisticsConfigurationsCopier.copyToBuilder(this.statisticsConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatisticsConfigurations(Collection<MetricStreamStatisticsConfiguration.BuilderImpl> statisticsConfigurations) {
            this.statisticsConfigurations = MetricStreamStatisticsConfigurationsCopier.copyFromBuilder(statisticsConfigurations);
        }

        @Override
        public final Builder statisticsConfigurations(Collection<MetricStreamStatisticsConfiguration> statisticsConfigurations) {
            this.statisticsConfigurations = MetricStreamStatisticsConfigurationsCopier.copy(statisticsConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsConfigurations(MetricStreamStatisticsConfiguration ... statisticsConfigurations) {
            this.statisticsConfigurations(Arrays.asList(statisticsConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsConfigurations(Consumer<MetricStreamStatisticsConfiguration.Builder> ... statisticsConfigurations) {
            this.statisticsConfigurations(Stream.of(statisticsConfigurations).map(c -> (MetricStreamStatisticsConfiguration)((MetricStreamStatisticsConfiguration.Builder)MetricStreamStatisticsConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIncludeLinkedAccountsMetrics() {
            return this.includeLinkedAccountsMetrics;
        }

        public final void setIncludeLinkedAccountsMetrics(Boolean includeLinkedAccountsMetrics) {
            this.includeLinkedAccountsMetrics = includeLinkedAccountsMetrics;
        }

        @Override
        public final Builder includeLinkedAccountsMetrics(Boolean includeLinkedAccountsMetrics) {
            this.includeLinkedAccountsMetrics = includeLinkedAccountsMetrics;
            return this;
        }

        @Override
        public GetMetricStreamResponse build() {
            return new GetMetricStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetricStreamResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder includeFilters(Collection<MetricStreamFilter> var1);

        public Builder includeFilters(MetricStreamFilter ... var1);

        public Builder includeFilters(Consumer<MetricStreamFilter.Builder> ... var1);

        public Builder excludeFilters(Collection<MetricStreamFilter> var1);

        public Builder excludeFilters(MetricStreamFilter ... var1);

        public Builder excludeFilters(Consumer<MetricStreamFilter.Builder> ... var1);

        public Builder firehoseArn(String var1);

        public Builder roleArn(String var1);

        public Builder state(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastUpdateDate(Instant var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(MetricStreamOutputFormat var1);

        public Builder statisticsConfigurations(Collection<MetricStreamStatisticsConfiguration> var1);

        public Builder statisticsConfigurations(MetricStreamStatisticsConfiguration ... var1);

        public Builder statisticsConfigurations(Consumer<MetricStreamStatisticsConfiguration.Builder> ... var1);

        public Builder includeLinkedAccountsMetrics(Boolean var1);
    }
}

