/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamFiltersCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat;
import software.amazon.awssdk.services.cloudwatch.model.Tag;
import software.amazon.awssdk.services.cloudwatch.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMetricStreamRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, PutMetricStreamRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PutMetricStreamRequest.getter(PutMetricStreamRequest::name)).setter(PutMetricStreamRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<MetricStreamFilter>> INCLUDE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeFilters").getter(PutMetricStreamRequest.getter(PutMetricStreamRequest::includeFilters)).setter(PutMetricStreamRequest.setter(Builder::includeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricStreamFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricStreamFilter>> EXCLUDE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeFilters").getter(PutMetricStreamRequest.getter(PutMetricStreamRequest::excludeFilters)).setter(PutMetricStreamRequest.setter(Builder::excludeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricStreamFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FIREHOSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirehoseArn").getter(PutMetricStreamRequest.getter(PutMetricStreamRequest::firehoseArn)).setter(PutMetricStreamRequest.setter(Builder::firehoseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(PutMetricStreamRequest.getter(PutMetricStreamRequest::roleArn)).setter(PutMetricStreamRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(PutMetricStreamRequest.getter(PutMetricStreamRequest::outputFormatAsString)).setter(PutMetricStreamRequest.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PutMetricStreamRequest.getter(PutMetricStreamRequest::tags)).setter(PutMetricStreamRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INCLUDE_FILTERS_FIELD, EXCLUDE_FILTERS_FIELD, FIREHOSE_ARN_FIELD, ROLE_ARN_FIELD, OUTPUT_FORMAT_FIELD, TAGS_FIELD));
    private final String name;
    private final List<MetricStreamFilter> includeFilters;
    private final List<MetricStreamFilter> excludeFilters;
    private final String firehoseArn;
    private final String roleArn;
    private final String outputFormat;
    private final List<Tag> tags;

    private PutMetricStreamRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.includeFilters = builder.includeFilters;
        this.excludeFilters = builder.excludeFilters;
        this.firehoseArn = builder.firehoseArn;
        this.roleArn = builder.roleArn;
        this.outputFormat = builder.outputFormat;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasIncludeFilters() {
        return this.includeFilters != null && !(this.includeFilters instanceof SdkAutoConstructList);
    }

    public final List<MetricStreamFilter> includeFilters() {
        return this.includeFilters;
    }

    public final boolean hasExcludeFilters() {
        return this.excludeFilters != null && !(this.excludeFilters instanceof SdkAutoConstructList);
    }

    public final List<MetricStreamFilter> excludeFilters() {
        return this.excludeFilters;
    }

    public final String firehoseArn() {
        return this.firehoseArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final MetricStreamOutputFormat outputFormat() {
        return MetricStreamOutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeFilters() ? this.includeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeFilters() ? this.excludeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.firehoseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricStreamRequest)) {
            return false;
        }
        PutMetricStreamRequest other = (PutMetricStreamRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasIncludeFilters() == other.hasIncludeFilters() && Objects.equals(this.includeFilters(), other.includeFilters()) && this.hasExcludeFilters() == other.hasExcludeFilters() && Objects.equals(this.excludeFilters(), other.excludeFilters()) && Objects.equals(this.firehoseArn(), other.firehoseArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PutMetricStreamRequest").add("Name", (Object)this.name()).add("IncludeFilters", this.hasIncludeFilters() ? this.includeFilters() : null).add("ExcludeFilters", this.hasExcludeFilters() ? this.excludeFilters() : null).add("FirehoseArn", (Object)this.firehoseArn()).add("RoleArn", (Object)this.roleArn()).add("OutputFormat", (Object)this.outputFormatAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IncludeFilters": {
                return Optional.ofNullable(clazz.cast(this.includeFilters()));
            }
            case "ExcludeFilters": {
                return Optional.ofNullable(clazz.cast(this.excludeFilters()));
            }
            case "FirehoseArn": {
                return Optional.ofNullable(clazz.cast(this.firehoseArn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMetricStreamRequest, T> g) {
        return obj -> g.apply((PutMetricStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<MetricStreamFilter> includeFilters = DefaultSdkAutoConstructList.getInstance();
        private List<MetricStreamFilter> excludeFilters = DefaultSdkAutoConstructList.getInstance();
        private String firehoseArn;
        private String roleArn;
        private String outputFormat;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricStreamRequest model) {
            super(model);
            this.name(model.name);
            this.includeFilters(model.includeFilters);
            this.excludeFilters(model.excludeFilters);
            this.firehoseArn(model.firehoseArn);
            this.roleArn(model.roleArn);
            this.outputFormat(model.outputFormat);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<MetricStreamFilter.Builder> getIncludeFilters() {
            List<MetricStreamFilter.Builder> result = MetricStreamFiltersCopier.copyToBuilder(this.includeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludeFilters(Collection<MetricStreamFilter.BuilderImpl> includeFilters) {
            this.includeFilters = MetricStreamFiltersCopier.copyFromBuilder(includeFilters);
        }

        @Override
        @Transient
        public final Builder includeFilters(Collection<MetricStreamFilter> includeFilters) {
            this.includeFilters = MetricStreamFiltersCopier.copy(includeFilters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includeFilters(MetricStreamFilter ... includeFilters) {
            this.includeFilters(Arrays.asList(includeFilters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includeFilters(Consumer<MetricStreamFilter.Builder> ... includeFilters) {
            this.includeFilters(Stream.of(includeFilters).map(c -> (MetricStreamFilter)((MetricStreamFilter.Builder)MetricStreamFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MetricStreamFilter.Builder> getExcludeFilters() {
            List<MetricStreamFilter.Builder> result = MetricStreamFiltersCopier.copyToBuilder(this.excludeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeFilters(Collection<MetricStreamFilter.BuilderImpl> excludeFilters) {
            this.excludeFilters = MetricStreamFiltersCopier.copyFromBuilder(excludeFilters);
        }

        @Override
        @Transient
        public final Builder excludeFilters(Collection<MetricStreamFilter> excludeFilters) {
            this.excludeFilters = MetricStreamFiltersCopier.copy(excludeFilters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder excludeFilters(MetricStreamFilter ... excludeFilters) {
            this.excludeFilters(Arrays.asList(excludeFilters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder excludeFilters(Consumer<MetricStreamFilter.Builder> ... excludeFilters) {
            this.excludeFilters(Stream.of(excludeFilters).map(c -> (MetricStreamFilter)((MetricStreamFilter.Builder)MetricStreamFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFirehoseArn() {
            return this.firehoseArn;
        }

        public final void setFirehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
        }

        @Override
        @Transient
        public final Builder firehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        @Transient
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder outputFormat(MetricStreamOutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricStreamRequest build() {
            return new PutMetricStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMetricStreamRequest> {
        public Builder name(String var1);

        public Builder includeFilters(Collection<MetricStreamFilter> var1);

        public Builder includeFilters(MetricStreamFilter ... var1);

        public Builder includeFilters(Consumer<MetricStreamFilter.Builder> ... var1);

        public Builder excludeFilters(Collection<MetricStreamFilter> var1);

        public Builder excludeFilters(MetricStreamFilter ... var1);

        public Builder excludeFilters(Consumer<MetricStreamFilter.Builder> ... var1);

        public Builder firehoseArn(String var1);

        public Builder roleArn(String var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(MetricStreamOutputFormat var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

