/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.DashboardNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDashboardsRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, DeleteDashboardsRequest> {
    private static final SdkField<List<String>> DASHBOARD_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DashboardNames").getter(DeleteDashboardsRequest.getter(DeleteDashboardsRequest::dashboardNames)).setter(DeleteDashboardsRequest.setter(Builder::dashboardNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_NAMES_FIELD));
    private final List<String> dashboardNames;

    private DeleteDashboardsRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardNames = builder.dashboardNames;
    }

    public final boolean hasDashboardNames() {
        return this.dashboardNames != null && !(this.dashboardNames instanceof SdkAutoConstructList);
    }

    public final List<String> dashboardNames() {
        return this.dashboardNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashboardNames() ? this.dashboardNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDashboardsRequest)) {
            return false;
        }
        DeleteDashboardsRequest other = (DeleteDashboardsRequest)((Object)obj);
        return this.hasDashboardNames() == other.hasDashboardNames() && Objects.equals(this.dashboardNames(), other.dashboardNames());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDashboardsRequest").add("DashboardNames", this.hasDashboardNames() ? this.dashboardNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardNames": {
                return Optional.ofNullable(clazz.cast(this.dashboardNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDashboardsRequest, T> g) {
        return obj -> g.apply((DeleteDashboardsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private List<String> dashboardNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDashboardsRequest model) {
            super(model);
            this.dashboardNames(model.dashboardNames);
        }

        public final Collection<String> getDashboardNames() {
            if (this.dashboardNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dashboardNames;
        }

        public final void setDashboardNames(Collection<String> dashboardNames) {
            this.dashboardNames = DashboardNamesCopier.copy(dashboardNames);
        }

        @Override
        @Transient
        public final Builder dashboardNames(Collection<String> dashboardNames) {
            this.dashboardNames = DashboardNamesCopier.copy(dashboardNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dashboardNames(String ... dashboardNames) {
            this.dashboardNames(Arrays.asList(dashboardNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDashboardsRequest build() {
            return new DeleteDashboardsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDashboardsRequest> {
        public Builder dashboardNames(Collection<String> var1);

        public Builder dashboardNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

