/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse;

public class ListManagedInsightRulesPublisher
implements SdkPublisher<ListManagedInsightRulesResponse> {
    private final CloudWatchAsyncClient client;
    private final ListManagedInsightRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedInsightRulesPublisher(CloudWatchAsyncClient client, ListManagedInsightRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedInsightRulesPublisher(CloudWatchAsyncClient client, ListManagedInsightRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedInsightRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedInsightRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListManagedInsightRulesResponseFetcher
    implements AsyncPageFetcher<ListManagedInsightRulesResponse> {
        private ListManagedInsightRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedInsightRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedInsightRulesResponse> nextPage(ListManagedInsightRulesResponse previousPage) {
            if (previousPage == null) {
                return ListManagedInsightRulesPublisher.this.client.listManagedInsightRules(ListManagedInsightRulesPublisher.this.firstRequest);
            }
            return ListManagedInsightRulesPublisher.this.client.listManagedInsightRules((ListManagedInsightRulesRequest)((Object)ListManagedInsightRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

