/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.Datapoint;
import software.amazon.awssdk.services.cloudwatch.model.DatapointsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetricStatisticsResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, GetMetricStatisticsResponse> {
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(GetMetricStatisticsResponse.getter(GetMetricStatisticsResponse::label)).setter(GetMetricStatisticsResponse.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<List<Datapoint>> DATAPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Datapoints").getter(GetMetricStatisticsResponse.getter(GetMetricStatisticsResponse::datapoints)).setter(GetMetricStatisticsResponse.setter(Builder::datapoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datapoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Datapoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_FIELD, DATAPOINTS_FIELD));
    private final String label;
    private final List<Datapoint> datapoints;

    private GetMetricStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.label = builder.label;
        this.datapoints = builder.datapoints;
    }

    public final String label() {
        return this.label;
    }

    public final boolean hasDatapoints() {
        return this.datapoints != null && !(this.datapoints instanceof SdkAutoConstructList);
    }

    public final List<Datapoint> datapoints() {
        return this.datapoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatapoints() ? this.datapoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsResponse)) {
            return false;
        }
        GetMetricStatisticsResponse other = (GetMetricStatisticsResponse)((Object)obj);
        return Objects.equals(this.label(), other.label()) && this.hasDatapoints() == other.hasDatapoints() && Objects.equals(this.datapoints(), other.datapoints());
    }

    public final String toString() {
        return ToString.builder((String)"GetMetricStatisticsResponse").add("Label", (Object)this.label()).add("Datapoints", this.hasDatapoints() ? this.datapoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "Datapoints": {
                return Optional.ofNullable(clazz.cast(this.datapoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricStatisticsResponse, T> g) {
        return obj -> g.apply((GetMetricStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private String label;
        private List<Datapoint> datapoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStatisticsResponse model) {
            super(model);
            this.label(model.label);
            this.datapoints(model.datapoints);
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final List<Datapoint.Builder> getDatapoints() {
            List<Datapoint.Builder> result = DatapointsCopier.copyToBuilder(this.datapoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatapoints(Collection<Datapoint.BuilderImpl> datapoints) {
            this.datapoints = DatapointsCopier.copyFromBuilder(datapoints);
        }

        @Override
        public final Builder datapoints(Collection<Datapoint> datapoints) {
            this.datapoints = DatapointsCopier.copy(datapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Datapoint ... datapoints) {
            this.datapoints(Arrays.asList(datapoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Consumer<Datapoint.Builder> ... datapoints) {
            this.datapoints(Stream.of(datapoints).map(c -> (Datapoint)((Datapoint.Builder)Datapoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMetricStatisticsResponse build() {
            return new GetMetricStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetricStatisticsResponse> {
        public Builder label(String var1);

        public Builder datapoints(Collection<Datapoint> var1);

        public Builder datapoints(Datapoint ... var1);

        public Builder datapoints(Consumer<Datapoint.Builder> ... var1);
    }
}

