/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse;

public class ListManagedInsightRulesIterable
implements SdkIterable<ListManagedInsightRulesResponse> {
    private final CloudWatchClient client;
    private final ListManagedInsightRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedInsightRulesIterable(CloudWatchClient client, ListManagedInsightRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListManagedInsightRulesResponseFetcher();
    }

    public Iterator<ListManagedInsightRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListManagedInsightRulesResponseFetcher
    implements SyncPageFetcher<ListManagedInsightRulesResponse> {
        private ListManagedInsightRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedInsightRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedInsightRulesResponse nextPage(ListManagedInsightRulesResponse previousPage) {
            if (previousPage == null) {
                return ListManagedInsightRulesIterable.this.client.listManagedInsightRules(ListManagedInsightRulesIterable.this.firstRequest);
            }
            return ListManagedInsightRulesIterable.this.client.listManagedInsightRules((ListManagedInsightRulesRequest)((Object)ListManagedInsightRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

