/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure includes the <code>Timezone</code> parameter, which you can use to specify your time zone so that the
 * labels that are associated with returned metrics display the correct time for your time zone.
 * </p>
 * <p>
 * The <code>Timezone</code> value affects a label only if you have a time-based dynamic expression in the label. For
 * more information about dynamic expressions in labels, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic
 * Labels</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelOptions implements SdkPojo, Serializable, ToCopyableBuilder<LabelOptions.Builder, LabelOptions> {
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(LabelOptions::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timezone;

    private LabelOptions(BuilderImpl builder) {
        this.timezone = builder.timezone;
    }

    /**
     * <p>
     * The time zone to use for metric data return in this operation. The format is <code>+</code> or <code>-</code>
     * followed by four digits. The first two digits indicate the number of hours ahead or behind of UTC, and the final
     * two digits are the number of minutes. For example, +0130 indicates a time zone that is 1 hour and 30 minutes
     * ahead of UTC. The default is +0000.
     * </p>
     * 
     * @return The time zone to use for metric data return in this operation. The format is <code>+</code> or
     *         <code>-</code> followed by four digits. The first two digits indicate the number of hours ahead or behind
     *         of UTC, and the final two digits are the number of minutes. For example, +0130 indicates a time zone that
     *         is 1 hour and 30 minutes ahead of UTC. The default is +0000.
     */
    public final String timezone() {
        return timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelOptions)) {
            return false;
        }
        LabelOptions other = (LabelOptions) obj;
        return Objects.equals(timezone(), other.timezone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelOptions").add("Timezone", timezone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelOptions, T> g) {
        return obj -> g.apply((LabelOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelOptions> {
        /**
         * <p>
         * The time zone to use for metric data return in this operation. The format is <code>+</code> or <code>-</code>
         * followed by four digits. The first two digits indicate the number of hours ahead or behind of UTC, and the
         * final two digits are the number of minutes. For example, +0130 indicates a time zone that is 1 hour and 30
         * minutes ahead of UTC. The default is +0000.
         * </p>
         * 
         * @param timezone
         *        The time zone to use for metric data return in this operation. The format is <code>+</code> or
         *        <code>-</code> followed by four digits. The first two digits indicate the number of hours ahead or
         *        behind of UTC, and the final two digits are the number of minutes. For example, +0130 indicates a time
         *        zone that is 1 hour and 30 minutes ahead of UTC. The default is +0000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);
    }

    static final class BuilderImpl implements Builder {
        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelOptions model) {
            timezone(model.timezone);
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public LabelOptions build() {
            return new LabelOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
