/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightRuleMetricDatapoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightRuleMetricDatapoint> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(InsightRuleMetricDatapoint.getter(InsightRuleMetricDatapoint::timestamp)).setter(InsightRuleMetricDatapoint.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<Double> UNIQUE_CONTRIBUTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UniqueContributors").getter(InsightRuleMetricDatapoint.getter(InsightRuleMetricDatapoint::uniqueContributors)).setter(InsightRuleMetricDatapoint.setter(Builder::uniqueContributors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueContributors").build()}).build();
    private static final SdkField<Double> MAX_CONTRIBUTOR_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxContributorValue").getter(InsightRuleMetricDatapoint.getter(InsightRuleMetricDatapoint::maxContributorValue)).setter(InsightRuleMetricDatapoint.setter(Builder::maxContributorValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxContributorValue").build()}).build();
    private static final SdkField<Double> SAMPLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SampleCount").getter(InsightRuleMetricDatapoint.getter(InsightRuleMetricDatapoint::sampleCount)).setter(InsightRuleMetricDatapoint.setter(Builder::sampleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleCount").build()}).build();
    private static final SdkField<Double> AVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Average").getter(InsightRuleMetricDatapoint.getter(InsightRuleMetricDatapoint::average)).setter(InsightRuleMetricDatapoint.setter(Builder::average)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Average").build()}).build();
    private static final SdkField<Double> SUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Sum").getter(InsightRuleMetricDatapoint.getter(InsightRuleMetricDatapoint::sum)).setter(InsightRuleMetricDatapoint.setter(Builder::sum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sum").build()}).build();
    private static final SdkField<Double> MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Minimum").getter(InsightRuleMetricDatapoint.getter(InsightRuleMetricDatapoint::minimum)).setter(InsightRuleMetricDatapoint.setter(Builder::minimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()}).build();
    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Maximum").getter(InsightRuleMetricDatapoint.getter(InsightRuleMetricDatapoint::maximum)).setter(InsightRuleMetricDatapoint.setter(Builder::maximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, UNIQUE_CONTRIBUTORS_FIELD, MAX_CONTRIBUTOR_VALUE_FIELD, SAMPLE_COUNT_FIELD, AVERAGE_FIELD, SUM_FIELD, MINIMUM_FIELD, MAXIMUM_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final Double uniqueContributors;
    private final Double maxContributorValue;
    private final Double sampleCount;
    private final Double average;
    private final Double sum;
    private final Double minimum;
    private final Double maximum;

    private InsightRuleMetricDatapoint(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.uniqueContributors = builder.uniqueContributors;
        this.maxContributorValue = builder.maxContributorValue;
        this.sampleCount = builder.sampleCount;
        this.average = builder.average;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final Double uniqueContributors() {
        return this.uniqueContributors;
    }

    public final Double maxContributorValue() {
        return this.maxContributorValue;
    }

    public final Double sampleCount() {
        return this.sampleCount;
    }

    public final Double average() {
        return this.average;
    }

    public final Double sum() {
        return this.sum;
    }

    public final Double minimum() {
        return this.minimum;
    }

    public final Double maximum() {
        return this.maximum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueContributors());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxContributorValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.average());
        hashCode = 31 * hashCode + Objects.hashCode(this.sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightRuleMetricDatapoint)) {
            return false;
        }
        InsightRuleMetricDatapoint other = (InsightRuleMetricDatapoint)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.uniqueContributors(), other.uniqueContributors()) && Objects.equals(this.maxContributorValue(), other.maxContributorValue()) && Objects.equals(this.sampleCount(), other.sampleCount()) && Objects.equals(this.average(), other.average()) && Objects.equals(this.sum(), other.sum()) && Objects.equals(this.minimum(), other.minimum()) && Objects.equals(this.maximum(), other.maximum());
    }

    public final String toString() {
        return ToString.builder((String)"InsightRuleMetricDatapoint").add("Timestamp", (Object)this.timestamp()).add("UniqueContributors", (Object)this.uniqueContributors()).add("MaxContributorValue", (Object)this.maxContributorValue()).add("SampleCount", (Object)this.sampleCount()).add("Average", (Object)this.average()).add("Sum", (Object)this.sum()).add("Minimum", (Object)this.minimum()).add("Maximum", (Object)this.maximum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "UniqueContributors": {
                return Optional.ofNullable(clazz.cast(this.uniqueContributors()));
            }
            case "MaxContributorValue": {
                return Optional.ofNullable(clazz.cast(this.maxContributorValue()));
            }
            case "SampleCount": {
                return Optional.ofNullable(clazz.cast(this.sampleCount()));
            }
            case "Average": {
                return Optional.ofNullable(clazz.cast(this.average()));
            }
            case "Sum": {
                return Optional.ofNullable(clazz.cast(this.sum()));
            }
            case "Minimum": {
                return Optional.ofNullable(clazz.cast(this.minimum()));
            }
            case "Maximum": {
                return Optional.ofNullable(clazz.cast(this.maximum()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightRuleMetricDatapoint, T> g) {
        return obj -> g.apply((InsightRuleMetricDatapoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private Double uniqueContributors;
        private Double maxContributorValue;
        private Double sampleCount;
        private Double average;
        private Double sum;
        private Double minimum;
        private Double maximum;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightRuleMetricDatapoint model) {
            this.timestamp(model.timestamp);
            this.uniqueContributors(model.uniqueContributors);
            this.maxContributorValue(model.maxContributorValue);
            this.sampleCount(model.sampleCount);
            this.average(model.average);
            this.sum(model.sum);
            this.minimum(model.minimum);
            this.maximum(model.maximum);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Double getUniqueContributors() {
            return this.uniqueContributors;
        }

        @Override
        public final Builder uniqueContributors(Double uniqueContributors) {
            this.uniqueContributors = uniqueContributors;
            return this;
        }

        public final void setUniqueContributors(Double uniqueContributors) {
            this.uniqueContributors = uniqueContributors;
        }

        public final Double getMaxContributorValue() {
            return this.maxContributorValue;
        }

        @Override
        public final Builder maxContributorValue(Double maxContributorValue) {
            this.maxContributorValue = maxContributorValue;
            return this;
        }

        public final void setMaxContributorValue(Double maxContributorValue) {
            this.maxContributorValue = maxContributorValue;
        }

        public final Double getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        public final Double getAverage() {
            return this.average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getSum() {
            return this.sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        public InsightRuleMetricDatapoint build() {
            return new InsightRuleMetricDatapoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightRuleMetricDatapoint> {
        public Builder timestamp(Instant var1);

        public Builder uniqueContributors(Double var1);

        public Builder maxContributorValue(Double var1);

        public Builder sampleCount(Double var1);

        public Builder average(Double var1);

        public Builder sum(Double var1);

        public Builder minimum(Double var1);

        public Builder maximum(Double var1);
    }
}

