/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm;
import software.amazon.awssdk.services.cloudwatch.model.CompositeAlarmsCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarmsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlarmsResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, DescribeAlarmsResponse> {
    private static final SdkField<List<CompositeAlarm>> COMPOSITE_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CompositeAlarms").getter(DescribeAlarmsResponse.getter(DescribeAlarmsResponse::compositeAlarms)).setter(DescribeAlarmsResponse.setter(Builder::compositeAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompositeAlarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricAlarm>> METRIC_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricAlarms").getter(DescribeAlarmsResponse.getter(DescribeAlarmsResponse::metricAlarms)).setter(DescribeAlarmsResponse.setter(Builder::metricAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricAlarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAlarmsResponse.getter(DescribeAlarmsResponse::nextToken)).setter(DescribeAlarmsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPOSITE_ALARMS_FIELD, METRIC_ALARMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CompositeAlarm> compositeAlarms;
    private final List<MetricAlarm> metricAlarms;
    private final String nextToken;

    private DescribeAlarmsResponse(BuilderImpl builder) {
        super(builder);
        this.compositeAlarms = builder.compositeAlarms;
        this.metricAlarms = builder.metricAlarms;
        this.nextToken = builder.nextToken;
    }

    public boolean hasCompositeAlarms() {
        return this.compositeAlarms != null && !(this.compositeAlarms instanceof SdkAutoConstructList);
    }

    public List<CompositeAlarm> compositeAlarms() {
        return this.compositeAlarms;
    }

    public boolean hasMetricAlarms() {
        return this.metricAlarms != null && !(this.metricAlarms instanceof SdkAutoConstructList);
    }

    public List<MetricAlarm> metricAlarms() {
        return this.metricAlarms;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.compositeAlarms());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAlarms());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsResponse)) {
            return false;
        }
        DescribeAlarmsResponse other = (DescribeAlarmsResponse)((Object)obj);
        return Objects.equals(this.compositeAlarms(), other.compositeAlarms()) && Objects.equals(this.metricAlarms(), other.metricAlarms()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAlarmsResponse").add("CompositeAlarms", this.compositeAlarms()).add("MetricAlarms", this.metricAlarms()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompositeAlarms": {
                return Optional.ofNullable(clazz.cast(this.compositeAlarms()));
            }
            case "MetricAlarms": {
                return Optional.ofNullable(clazz.cast(this.metricAlarms()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmsResponse, T> g) {
        return obj -> g.apply((DescribeAlarmsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<CompositeAlarm> compositeAlarms = DefaultSdkAutoConstructList.getInstance();
        private List<MetricAlarm> metricAlarms = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsResponse model) {
            super(model);
            this.compositeAlarms(model.compositeAlarms);
            this.metricAlarms(model.metricAlarms);
            this.nextToken(model.nextToken);
        }

        public final Collection<CompositeAlarm.Builder> getCompositeAlarms() {
            return this.compositeAlarms != null ? (Collection)this.compositeAlarms.stream().map(CompositeAlarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder compositeAlarms(Collection<CompositeAlarm> compositeAlarms) {
            this.compositeAlarms = CompositeAlarmsCopier.copy(compositeAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositeAlarms(CompositeAlarm ... compositeAlarms) {
            this.compositeAlarms(Arrays.asList(compositeAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositeAlarms(Consumer<CompositeAlarm.Builder> ... compositeAlarms) {
            this.compositeAlarms(Stream.of(compositeAlarms).map(c -> (CompositeAlarm)((CompositeAlarm.Builder)CompositeAlarm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCompositeAlarms(Collection<CompositeAlarm.BuilderImpl> compositeAlarms) {
            this.compositeAlarms = CompositeAlarmsCopier.copyFromBuilder(compositeAlarms);
        }

        public final Collection<MetricAlarm.Builder> getMetricAlarms() {
            return this.metricAlarms != null ? (Collection)this.metricAlarms.stream().map(MetricAlarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(MetricAlarm ... metricAlarms) {
            this.metricAlarms(Arrays.asList(metricAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(Consumer<MetricAlarm.Builder> ... metricAlarms) {
            this.metricAlarms(Stream.of(metricAlarms).map(c -> (MetricAlarm)((MetricAlarm.Builder)MetricAlarm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricAlarms(Collection<MetricAlarm.BuilderImpl> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copyFromBuilder(metricAlarms);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAlarmsResponse build() {
            return new DescribeAlarmsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAlarmsResponse> {
        public Builder compositeAlarms(Collection<CompositeAlarm> var1);

        public Builder compositeAlarms(CompositeAlarm ... var1);

        public Builder compositeAlarms(Consumer<CompositeAlarm.Builder> ... var1);

        public Builder metricAlarms(Collection<MetricAlarm> var1);

        public Builder metricAlarms(MetricAlarm ... var1);

        public Builder metricAlarms(Consumer<MetricAlarm.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

