/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration;
import software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyDetector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyDetector> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(AnomalyDetector.getter(AnomalyDetector::namespace)).setter(AnomalyDetector.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(AnomalyDetector.getter(AnomalyDetector::metricName)).setter(AnomalyDetector.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(AnomalyDetector.getter(AnomalyDetector::dimensions)).setter(AnomalyDetector.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stat").getter(AnomalyDetector.getter(AnomalyDetector::stat)).setter(AnomalyDetector.setter(Builder::stat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stat").build()}).build();
    private static final SdkField<AnomalyDetectorConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(AnomalyDetector.getter(AnomalyDetector::configuration)).setter(AnomalyDetector.setter(Builder::configuration)).constructor(AnomalyDetectorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateValue").getter(AnomalyDetector.getter(AnomalyDetector::stateValueAsString)).setter(AnomalyDetector.setter(Builder::stateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, METRIC_NAME_FIELD, DIMENSIONS_FIELD, STAT_FIELD, CONFIGURATION_FIELD, STATE_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String metricName;
    private final List<Dimension> dimensions;
    private final String stat;
    private final AnomalyDetectorConfiguration configuration;
    private final String stateValue;

    private AnomalyDetector(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.stat = builder.stat;
        this.configuration = builder.configuration;
        this.stateValue = builder.stateValue;
    }

    public String namespace() {
        return this.namespace;
    }

    public String metricName() {
        return this.metricName;
    }

    public boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public String stat() {
        return this.stat;
    }

    public AnomalyDetectorConfiguration configuration() {
        return this.configuration;
    }

    public AnomalyDetectorStateValue stateValue() {
        return AnomalyDetectorStateValue.fromValue(this.stateValue);
    }

    public String stateValueAsString() {
        return this.stateValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.stat());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateValueAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetector)) {
            return false;
        }
        AnomalyDetector other = (AnomalyDetector)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.stat(), other.stat()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.stateValueAsString(), other.stateValueAsString());
    }

    public String toString() {
        return ToString.builder((String)"AnomalyDetector").add("Namespace", (Object)this.namespace()).add("MetricName", (Object)this.metricName()).add("Dimensions", this.dimensions()).add("Stat", (Object)this.stat()).add("Configuration", (Object)this.configuration()).add("StateValue", (Object)this.stateValueAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Stat": {
                return Optional.ofNullable(clazz.cast(this.stat()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "StateValue": {
                return Optional.ofNullable(clazz.cast(this.stateValueAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetector, T> g) {
        return obj -> g.apply((AnomalyDetector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private String metricName;
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private String stat;
        private AnomalyDetectorConfiguration configuration;
        private String stateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetector model) {
            this.namespace(model.namespace);
            this.metricName(model.metricName);
            this.dimensions(model.dimensions);
            this.stat(model.stat);
            this.configuration(model.configuration);
            this.stateValue(model.stateValue);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<Dimension.Builder> getDimensions() {
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(Dimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        public final String getStat() {
            return this.stat;
        }

        @Override
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        public final AnomalyDetectorConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(AnomalyDetectorConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(AnomalyDetectorConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final String getStateValue() {
            return this.stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(AnomalyDetectorStateValue stateValue) {
            this.stateValue(stateValue == null ? null : stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public AnomalyDetector build() {
            return new AnomalyDetector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyDetector> {
        public Builder namespace(String var1);

        public Builder metricName(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);

        public Builder stat(String var1);

        public Builder configuration(AnomalyDetectorConfiguration var1);

        default public Builder configuration(Consumer<AnomalyDetectorConfiguration.Builder> configuration) {
            return this.configuration((AnomalyDetectorConfiguration)((AnomalyDetectorConfiguration.Builder)AnomalyDetectorConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder stateValue(String var1);

        public Builder stateValue(AnomalyDetectorStateValue var1);
    }
}

