/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.Tag;
import software.amazon.awssdk.services.cloudwatch.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutInsightRuleRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, PutInsightRuleRequest> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutInsightRuleRequest.getter(PutInsightRuleRequest::ruleName)).setter(PutInsightRuleRequest.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> RULE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutInsightRuleRequest.getter(PutInsightRuleRequest::ruleState)).setter(PutInsightRuleRequest.setter(Builder::ruleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleState").build()}).build();
    private static final SdkField<String> RULE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutInsightRuleRequest.getter(PutInsightRuleRequest::ruleDefinition)).setter(PutInsightRuleRequest.setter(Builder::ruleDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleDefinition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutInsightRuleRequest.getter(PutInsightRuleRequest::tags)).setter(PutInsightRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, RULE_STATE_FIELD, RULE_DEFINITION_FIELD, TAGS_FIELD));
    private final String ruleName;
    private final String ruleState;
    private final String ruleDefinition;
    private final List<Tag> tags;

    private PutInsightRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.ruleState = builder.ruleState;
        this.ruleDefinition = builder.ruleDefinition;
        this.tags = builder.tags;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public String ruleState() {
        return this.ruleState;
    }

    public String ruleDefinition() {
        return this.ruleDefinition;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleState());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInsightRuleRequest)) {
            return false;
        }
        PutInsightRuleRequest other = (PutInsightRuleRequest)((Object)obj);
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.ruleState(), other.ruleState()) && Objects.equals(this.ruleDefinition(), other.ruleDefinition()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"PutInsightRuleRequest").add("RuleName", (Object)this.ruleName()).add("RuleState", (Object)this.ruleState()).add("RuleDefinition", (Object)this.ruleDefinition()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "RuleState": {
                return Optional.ofNullable(clazz.cast(this.ruleState()));
            }
            case "RuleDefinition": {
                return Optional.ofNullable(clazz.cast(this.ruleDefinition()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutInsightRuleRequest, T> g) {
        return obj -> g.apply((PutInsightRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String ruleName;
        private String ruleState;
        private String ruleDefinition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutInsightRuleRequest model) {
            super(model);
            this.ruleName(model.ruleName);
            this.ruleState(model.ruleState);
            this.ruleDefinition(model.ruleDefinition);
            this.tags(model.tags);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getRuleState() {
            return this.ruleState;
        }

        @Override
        public final Builder ruleState(String ruleState) {
            this.ruleState = ruleState;
            return this;
        }

        public final void setRuleState(String ruleState) {
            this.ruleState = ruleState;
        }

        public final String getRuleDefinition() {
            return this.ruleDefinition;
        }

        @Override
        public final Builder ruleDefinition(String ruleDefinition) {
            this.ruleDefinition = ruleDefinition;
            return this;
        }

        public final void setRuleDefinition(String ruleDefinition) {
            this.ruleDefinition = ruleDefinition;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInsightRuleRequest build() {
            return new PutInsightRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutInsightRuleRequest> {
        public Builder ruleName(String var1);

        public Builder ruleState(String var1);

        public Builder ruleDefinition(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

