/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.InsightRule;
import software.amazon.awssdk.services.cloudwatch.model.InsightRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInsightRulesResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, DescribeInsightRulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeInsightRulesResponse.getter(DescribeInsightRulesResponse::nextToken)).setter(DescribeInsightRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<InsightRule>> INSIGHT_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeInsightRulesResponse.getter(DescribeInsightRulesResponse::insightRules)).setter(DescribeInsightRulesResponse.setter(Builder::insightRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, INSIGHT_RULES_FIELD));
    private final String nextToken;
    private final List<InsightRule> insightRules;

    private DescribeInsightRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.insightRules = builder.insightRules;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<InsightRule> insightRules() {
        return this.insightRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInsightRulesResponse)) {
            return false;
        }
        DescribeInsightRulesResponse other = (DescribeInsightRulesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.insightRules(), other.insightRules());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInsightRulesResponse").add("NextToken", (Object)this.nextToken()).add("InsightRules", this.insightRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "InsightRules": {
                return Optional.ofNullable(clazz.cast(this.insightRules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInsightRulesResponse, T> g) {
        return obj -> g.apply((DescribeInsightRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<InsightRule> insightRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInsightRulesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.insightRules(model.insightRules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<InsightRule.Builder> getInsightRules() {
            return this.insightRules != null ? (Collection)this.insightRules.stream().map(InsightRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder insightRules(Collection<InsightRule> insightRules) {
            this.insightRules = InsightRulesCopier.copy(insightRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightRules(InsightRule ... insightRules) {
            this.insightRules(Arrays.asList(insightRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightRules(Consumer<InsightRule.Builder> ... insightRules) {
            this.insightRules(Stream.of(insightRules).map(c -> (InsightRule)((InsightRule.Builder)InsightRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInsightRules(Collection<InsightRule.BuilderImpl> insightRules) {
            this.insightRules = InsightRulesCopier.copyFromBuilder(insightRules);
        }

        @Override
        public DescribeInsightRulesResponse build() {
            return new DescribeInsightRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInsightRulesResponse> {
        public Builder nextToken(String var1);

        public Builder insightRules(Collection<InsightRule> var1);

        public Builder insightRules(InsightRule ... var1);

        public Builder insightRules(Consumer<InsightRule.Builder> ... var1);
    }
}

