/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;

public class DescribeAlarmsIterable
implements SdkIterable<DescribeAlarmsResponse> {
    private final CloudWatchClient client;
    private final DescribeAlarmsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAlarmsIterable(CloudWatchClient client, DescribeAlarmsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAlarmsResponseFetcher();
    }

    public Iterator<DescribeAlarmsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetricAlarm> metricAlarms() {
        Function<DescribeAlarmsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricAlarms() != null) {
                return response.metricAlarms().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeAlarmsIterable resume(DescribeAlarmsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAlarmsIterable(this.client, (DescribeAlarmsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAlarmsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeAlarmsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeAlarmsResponseFetcher
    implements SyncPageFetcher<DescribeAlarmsResponse> {
        private DescribeAlarmsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAlarmsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAlarmsResponse nextPage(DescribeAlarmsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAlarmsIterable.this.client.describeAlarms(DescribeAlarmsIterable.this.firstRequest);
            }
            return DescribeAlarmsIterable.this.client.describeAlarms((DescribeAlarmsRequest)((Object)DescribeAlarmsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

