/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CountsCopier;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;
import software.amazon.awssdk.services.cloudwatch.model.ValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDatum
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricDatum> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricDatum.getter(MetricDatum::metricName)).setter(MetricDatum.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MetricDatum.getter(MetricDatum::dimensions)).setter(MetricDatum.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MetricDatum.getter(MetricDatum::timestamp)).setter(MetricDatum.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(MetricDatum.getter(MetricDatum::value)).setter(MetricDatum.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<StatisticSet> STATISTIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MetricDatum.getter(MetricDatum::statisticValues)).setter(MetricDatum.setter(Builder::statisticValues)).constructor(StatisticSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticValues").build()}).build();
    private static final SdkField<List<Double>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MetricDatum.getter(MetricDatum::values)).setter(MetricDatum.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MetricDatum.getter(MetricDatum::counts)).setter(MetricDatum.setter(Builder::counts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Counts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricDatum.getter(MetricDatum::unitAsString)).setter(MetricDatum.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<Integer> STORAGE_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MetricDatum.getter(MetricDatum::storageResolution)).setter(MetricDatum.setter(Builder::storageResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageResolution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, DIMENSIONS_FIELD, TIMESTAMP_FIELD, VALUE_FIELD, STATISTIC_VALUES_FIELD, VALUES_FIELD, COUNTS_FIELD, UNIT_FIELD, STORAGE_RESOLUTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final List<Dimension> dimensions;
    private final Instant timestamp;
    private final Double value;
    private final StatisticSet statisticValues;
    private final List<Double> values;
    private final List<Double> counts;
    private final String unit;
    private final Integer storageResolution;

    private MetricDatum(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.timestamp = builder.timestamp;
        this.value = builder.value;
        this.statisticValues = builder.statisticValues;
        this.values = builder.values;
        this.counts = builder.counts;
        this.unit = builder.unit;
        this.storageResolution = builder.storageResolution;
    }

    public String metricName() {
        return this.metricName;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Double value() {
        return this.value;
    }

    public StatisticSet statisticValues() {
        return this.statisticValues;
    }

    public List<Double> values() {
        return this.values;
    }

    public List<Double> counts() {
        return this.counts;
    }

    public StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    public Integer storageResolution() {
        return this.storageResolution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        hashCode = 31 * hashCode + Objects.hashCode(this.counts());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageResolution());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatum)) {
            return false;
        }
        MetricDatum other = (MetricDatum)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.statisticValues(), other.statisticValues()) && Objects.equals(this.values(), other.values()) && Objects.equals(this.counts(), other.counts()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.storageResolution(), other.storageResolution());
    }

    public String toString() {
        return ToString.builder((String)"MetricDatum").add("MetricName", (Object)this.metricName()).add("Dimensions", this.dimensions()).add("Timestamp", (Object)this.timestamp()).add("Value", (Object)this.value()).add("StatisticValues", (Object)this.statisticValues()).add("Values", this.values()).add("Counts", this.counts()).add("Unit", (Object)this.unitAsString()).add("StorageResolution", (Object)this.storageResolution()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "StatisticValues": {
                return Optional.ofNullable(clazz.cast(this.statisticValues()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "Counts": {
                return Optional.ofNullable(clazz.cast(this.counts()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "StorageResolution": {
                return Optional.ofNullable(clazz.cast(this.storageResolution()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDatum, T> g) {
        return obj -> g.apply((MetricDatum)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private Instant timestamp;
        private Double value;
        private StatisticSet statisticValues;
        private List<Double> values = DefaultSdkAutoConstructList.getInstance();
        private List<Double> counts = DefaultSdkAutoConstructList.getInstance();
        private String unit;
        private Integer storageResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDatum model) {
            this.metricName(model.metricName);
            this.dimensions(model.dimensions);
            this.timestamp(model.timestamp);
            this.value(model.value);
            this.statisticValues(model.statisticValues);
            this.values(model.values);
            this.counts(model.counts);
            this.unit(model.unit);
            this.storageResolution(model.storageResolution);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<Dimension.Builder> getDimensions() {
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(Dimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Double getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        public final StatisticSet.Builder getStatisticValues() {
            return this.statisticValues != null ? this.statisticValues.toBuilder() : null;
        }

        @Override
        public final Builder statisticValues(StatisticSet statisticValues) {
            this.statisticValues = statisticValues;
            return this;
        }

        public final void setStatisticValues(StatisticSet.BuilderImpl statisticValues) {
            this.statisticValues = statisticValues != null ? statisticValues.build() : null;
        }

        public final Collection<Double> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<Double> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Double ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<Double> values) {
            this.values = ValuesCopier.copy(values);
        }

        public final Collection<Double> getCounts() {
            return this.counts;
        }

        @Override
        public final Builder counts(Collection<Double> counts) {
            this.counts = CountsCopier.copy(counts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder counts(Double ... counts) {
            this.counts(Arrays.asList(counts));
            return this;
        }

        public final void setCounts(Collection<Double> counts) {
            this.counts = CountsCopier.copy(counts);
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Integer getStorageResolution() {
            return this.storageResolution;
        }

        @Override
        public final Builder storageResolution(Integer storageResolution) {
            this.storageResolution = storageResolution;
            return this;
        }

        public final void setStorageResolution(Integer storageResolution) {
            this.storageResolution = storageResolution;
        }

        public MetricDatum build() {
            return new MetricDatum(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricDatum> {
        public Builder metricName(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);

        public Builder timestamp(Instant var1);

        public Builder value(Double var1);

        public Builder statisticValues(StatisticSet var1);

        default public Builder statisticValues(Consumer<StatisticSet.Builder> statisticValues) {
            return this.statisticValues((StatisticSet)((StatisticSet.Builder)StatisticSet.builder().applyMutation(statisticValues)).build());
        }

        public Builder values(Collection<Double> var1);

        public Builder values(Double ... var1);

        public Builder counts(Collection<Double> var1);

        public Builder counts(Double ... var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);

        public Builder storageResolution(Integer var1);
    }
}

