/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMetricDataRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, PutMetricDataRequest> {
    private final String namespace;
    private final List<MetricDatum> metricData;

    private PutMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
        this.metricData = builder.metricData;
    }

    public String namespace() {
        return this.namespace;
    }

    public List<MetricDatum> metricData() {
        return this.metricData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricDataRequest)) {
            return false;
        }
        PutMetricDataRequest other = (PutMetricDataRequest)((Object)obj);
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.metricData(), other.metricData());
    }

    public String toString() {
        return ToString.builder((String)"PutMetricDataRequest").add("Namespace", (Object)this.namespace()).add("MetricData", this.metricData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "MetricData": {
                return Optional.ofNullable(clazz.cast(this.metricData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String namespace;
        private List<MetricDatum> metricData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricDataRequest model) {
            super(model);
            this.namespace(model.namespace);
            this.metricData(model.metricData);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Collection<MetricDatum.Builder> getMetricData() {
            return this.metricData != null ? (Collection)this.metricData.stream().map(MetricDatum::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricData(Collection<MetricDatum> metricData) {
            this.metricData = MetricDataCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatum ... metricData) {
            this.metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(Consumer<MetricDatum.Builder> ... metricData) {
            this.metricData(Stream.of(metricData).map(c -> (MetricDatum)((MetricDatum.Builder)MetricDatum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricData(Collection<MetricDatum.BuilderImpl> metricData) {
            this.metricData = MetricDataCopier.copyFromBuilder(metricData);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricDataRequest build() {
            return new PutMetricDataRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    CopyableBuilder<Builder, PutMetricDataRequest> {
        public Builder namespace(String var1);

        public Builder metricData(Collection<MetricDatum> var1);

        public Builder metricData(MetricDatum ... var1);

        public Builder metricData(Consumer<MetricDatum.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

