/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.DashboardNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDashboardsRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, DeleteDashboardsRequest> {
    private final List<String> dashboardNames;

    private DeleteDashboardsRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardNames = builder.dashboardNames;
    }

    public List<String> dashboardNames() {
        return this.dashboardNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDashboardsRequest)) {
            return false;
        }
        DeleteDashboardsRequest other = (DeleteDashboardsRequest)((Object)obj);
        return Objects.equals(this.dashboardNames(), other.dashboardNames());
    }

    public String toString() {
        return ToString.builder((String)"DeleteDashboardsRequest").add("DashboardNames", this.dashboardNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardNames": {
                return Optional.ofNullable(clazz.cast(this.dashboardNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private List<String> dashboardNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDashboardsRequest model) {
            super(model);
            this.dashboardNames(model.dashboardNames);
        }

        public final Collection<String> getDashboardNames() {
            return this.dashboardNames;
        }

        @Override
        public final Builder dashboardNames(Collection<String> dashboardNames) {
            this.dashboardNames = DashboardNamesCopier.copy(dashboardNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardNames(String ... dashboardNames) {
            this.dashboardNames(Arrays.asList(dashboardNames));
            return this;
        }

        public final void setDashboardNames(Collection<String> dashboardNames) {
            this.dashboardNames = DashboardNamesCopier.copy(dashboardNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDashboardsRequest build() {
            return new DeleteDashboardsRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    CopyableBuilder<Builder, DeleteDashboardsRequest> {
        public Builder dashboardNames(Collection<String> var1);

        public Builder dashboardNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

