/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.Metric;
import software.amazon.awssdk.services.cloudwatch.model.MetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMetricsResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, ListMetricsResponse> {
    private final List<Metric> metrics;
    private final String nextToken;

    private ListMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
    }

    public List<Metric> metrics() {
        return this.metrics;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricsResponse)) {
            return false;
        }
        ListMetricsResponse other = (ListMetricsResponse)((Object)obj);
        return Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListMetricsResponse").add("Metrics", this.metrics()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<Metric> metrics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricsResponse model) {
            super(model);
            this.metrics(model.metrics);
            this.nextToken(model.nextToken);
        }

        public final Collection<Metric.Builder> getMetrics() {
            return this.metrics != null ? (Collection)this.metrics.stream().map(Metric::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metrics(Collection<Metric> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Metric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<Metric.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (Metric)((Metric.Builder)Metric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetrics(Collection<Metric.BuilderImpl> metrics) {
            this.metrics = MetricsCopier.copyFromBuilder(metrics);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMetricsResponse build() {
            return new ListMetricsResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    CopyableBuilder<Builder, ListMetricsResponse> {
        public Builder metrics(Collection<Metric> var1);

        public Builder metrics(Metric ... var1);

        public Builder metrics(Consumer<Metric.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

